/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.homes.api;

import com.serveressentials.api.home.Home;
import com.serveressentials.api.home.HomeAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.homes.HomeManager;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class HomeAPIImpl
implements HomeAPI {
    private final HomeManager homeManager;

    public HomeAPIImpl(HomeManager homeManager) {
        this.homeManager = homeManager;
    }

    @Override
    public CompletableFuture<Boolean> setHome(Player player, int slot, String name, Location location) {
        net.godlycow.org.homes.model.Home internalHome = new net.godlycow.org.homes.model.Home(name, location);
        return this.homeManager.setHome(player.getUniqueId(), slot, internalHome);
    }

    @Override
    public CompletableFuture<Optional<Home>> getHome(Player player, int slot) {
        return this.homeManager.getHome(player.getUniqueId(), slot).thenApply(opt -> {
            if (opt.isPresent()) {
                net.godlycow.org.homes.model.Home internal = (net.godlycow.org.homes.model.Home)opt.get();
                return Optional.of(new Home(internal.getName(), internal.toLocation()));
            }
            return Optional.empty();
        });
    }

    @Override
    public CompletableFuture<Map<Integer, Home>> getAllHomes(Player player) {
        return this.homeManager.getAllHomes(player.getUniqueId()).thenApply(map -> {
            HashMap<Integer, Home> result = new HashMap<Integer, Home>();
            for (Map.Entry entry : map.entrySet()) {
                net.godlycow.org.homes.model.Home h = (net.godlycow.org.homes.model.Home)entry.getValue();
                if (h == null || h.toLocation() == null) continue;
                result.put((Integer)entry.getKey(), new Home(h.getName(), h.toLocation()));
            }
            return result;
        });
    }

    @Override
    public CompletableFuture<Boolean> removeHome(Player player, int slot) {
        return this.homeManager.removeHome(player.getUniqueId(), slot);
    }

    @Override
    public int getMaxHomes(Player player) {
        return this.homeManager.config.maxHomes;
    }

    @Override
    public CompletableFuture<Integer> getHomeCount(Player player) {
        return this.homeManager.countHomes(player.getUniqueId());
    }
}

