/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.homes;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.godlycow.org.commands.config.HomesConfig;
import net.godlycow.org.homes.model.Home;
import net.godlycow.org.homes.storage.HomeStorage;
import org.bukkit.Bukkit;

public class HomeManager {
    private final HomeStorage storage;
    public final HomesConfig config;
    private final Map<UUID, Long> lastSetTimes = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastTeleportTimes = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Map<Integer, Home>> homeCache = new ConcurrentHashMap<UUID, Map<Integer, Home>>();

    public HomeManager(HomeStorage storage, HomesConfig config) {
        this.storage = storage;
        this.config = config;
    }

    public CompletableFuture<Optional<Home>> getHome(UUID playerId, int slot) {
        return this.storage.getHome(playerId, slot).exceptionally(ex -> {
            Bukkit.getLogger().log(Level.WARNING, "Failed to fetch home for " + String.valueOf(playerId) + " slot " + slot, (Throwable)ex);
            return Optional.empty();
        });
    }

    public CompletableFuture<Boolean> setHome(UUID playerId, int slot, Home home) {
        if (slot < 1 || slot > this.config.maxHomes) {
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)this.storage.setHome(playerId, slot, home).thenApply(v -> {
            this.lastSetTimes.put(playerId, System.currentTimeMillis());
            this.homeCache.computeIfAbsent(playerId, k -> new HashMap()).put(slot, home);
            return true;
        })).exceptionally(ex -> {
            Bukkit.getLogger().log(Level.WARNING, "Failed to set home for " + String.valueOf(playerId), (Throwable)ex);
            return false;
        });
    }

    public CompletableFuture<Boolean> removeHome(UUID playerId, int slot) {
        return ((CompletableFuture)this.storage.removeHome(playerId, slot).thenApply(v -> {
            if (this.homeCache.containsKey(playerId)) {
                this.homeCache.get(playerId).remove(slot);
            }
            return true;
        })).exceptionally(ex -> {
            Bukkit.getLogger().log(Level.WARNING, "Failed to remove home for " + String.valueOf(playerId), (Throwable)ex);
            return false;
        });
    }

    public CompletableFuture<Map<Integer, Home>> getAllHomes(UUID playerId) {
        return ((CompletableFuture)this.storage.getAllHomes(playerId).thenApply(homes -> {
            HashMap<Integer, Home> validHomes = new HashMap<Integer, Home>();
            for (Map.Entry entry : homes.entrySet()) {
                if (entry.getValue() == null || ((Home)entry.getValue()).toLocation() == null) continue;
                validHomes.put((Integer)entry.getKey(), (Home)entry.getValue());
            }
            this.homeCache.put(playerId, validHomes);
            return validHomes;
        })).exceptionally(ex -> {
            Bukkit.getLogger().log(Level.WARNING, "Failed to fetch all homes for " + String.valueOf(playerId), (Throwable)ex);
            return new HashMap();
        });
    }

    public CompletableFuture<Integer> countHomes(UUID playerId) {
        return this.getAllHomes(playerId).thenApply(Map::size);
    }

    public boolean canSetHome(UUID playerId) {
        if (this.config.setCooldownSeconds <= 0) {
            return true;
        }
        Long lastSet = this.lastSetTimes.get(playerId);
        if (lastSet == null) {
            return true;
        }
        long elapsed = (System.currentTimeMillis() - lastSet) / 1000L;
        return elapsed >= (long)this.config.setCooldownSeconds;
    }

    public long getRemainingSetCooldown(UUID playerId) {
        if (this.config.setCooldownSeconds <= 0) {
            return 0L;
        }
        Long lastSet = this.lastSetTimes.get(playerId);
        if (lastSet == null) {
            return 0L;
        }
        long elapsed = (System.currentTimeMillis() - lastSet) / 1000L;
        return Math.max(0L, (long)this.config.setCooldownSeconds - elapsed);
    }

    public boolean canTeleport(UUID playerId) {
        if (this.config.teleportCooldownSeconds <= 0) {
            return true;
        }
        Long lastTeleport = this.lastTeleportTimes.get(playerId);
        if (lastTeleport == null) {
            return true;
        }
        long elapsed = (System.currentTimeMillis() - lastTeleport) / 1000L;
        return elapsed >= (long)this.config.teleportCooldownSeconds;
    }

    public long getRemainingTeleportCooldown(UUID playerId) {
        if (this.config.teleportCooldownSeconds <= 0) {
            return 0L;
        }
        Long lastTeleport = this.lastTeleportTimes.get(playerId);
        if (lastTeleport == null) {
            return 0L;
        }
        long elapsed = (System.currentTimeMillis() - lastTeleport) / 1000L;
        return Math.max(0L, (long)this.config.teleportCooldownSeconds - elapsed);
    }

    public void updateLastTeleportTime(UUID playerId) {
        this.lastTeleportTimes.put(playerId, System.currentTimeMillis());
    }

    public void reload() {
        this.config.reload();
        this.homeCache.clear();
        Bukkit.getLogger().info("[ServerEssentials] Home system reloaded");
    }

    public void clearCooldowns(UUID playerId) {
        this.lastSetTimes.remove(playerId);
        this.lastTeleportTimes.remove(playerId);
    }

    public void clearCache() {
        this.homeCache.clear();
    }
}

