/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.executor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class FirstInstallCommandRunner {
    private final Plugin plugin;
    private final File flagFile;
    private final List<String> commands;

    public FirstInstallCommandRunner(Plugin plugin) {
        this.plugin = plugin;
        this.flagFile = new File(plugin.getDataFolder(), ".installed");
        this.commands = List.of("papi ecloud download Vault", "papi ecloud download Statistic", "papi ecloud download Server", "language reload");
    }

    public void runIfFirstInstall() {
        if (!this.flagFile.exists()) {
            this.plugin.getLogger().info("First install detected \u2013 running commands...");
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
                    this.plugin.getLogger().severe("PlaceholderAPI not found! Skipping first-install commands.");
                    return;
                }
                long delay = 0L;
                for (String cmd : this.commands) {
                    long finalDelay = delay;
                    Bukkit.getScheduler().runTaskLater(this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd), finalDelay);
                    delay += 60L;
                }
                Bukkit.getScheduler().runTaskLater(this.plugin, this::markAsInstalled, delay + 20L);
            }, 200L);
        }
    }

    private void markAsInstalled() {
        try {
            this.flagFile.getParentFile().mkdirs();
            this.flagFile.createNewFile();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create first-install flag file \u2013 commands may re-run on restart!");
            e.printStackTrace();
        }
    }
}

