/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.vault;

import java.util.List;
import java.util.UUID;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.economy.eco.InternalEconomy;
import net.godlycow.org.util.logger.AnsiColorUtil;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class VaultEconomyWrapper
implements Economy {
    private final InternalEconomy economy;
    private final String name;

    public VaultEconomyWrapper(InternalEconomy economy, String name) {
        this.economy = economy;
        this.name = name;
    }

    public boolean isEnabled() {
        return this.economy.isEnabled();
    }

    public String getName() {
        return this.name;
    }

    public String format(double amount) {
        return this.economy.format(amount);
    }

    public boolean hasAccount(OfflinePlayer player) {
        try {
            return this.economy.hasAccount(player);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning(AnsiColorUtil.danger("VaultEconomyWrapper: Error checking account for " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean hasAccount(String identifier) {
        return this.hasAccount(this.resolvePlayer(identifier));
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public boolean hasAccount(String identifier, String worldName) {
        return this.hasAccount(this.resolvePlayer(identifier));
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        try {
            return this.economy.createPlayerAccount(player);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning(AnsiColorUtil.danger("VaultEconomyWrapper: Error creating account for " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean createPlayerAccount(String identifier) {
        return this.createPlayerAccount(this.resolvePlayer(identifier));
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player);
    }

    public boolean createPlayerAccount(String identifier, String worldName) {
        return this.createPlayerAccount(this.resolvePlayer(identifier));
    }

    public double getBalance(OfflinePlayer player) {
        try {
            return this.economy.getBalance(player);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning(AnsiColorUtil.danger("VaultEconomyWrapper: Error getting balance for " + player.getName() + ": " + e.getMessage()));
            return 0.0;
        }
    }

    public double getBalance(String identifier) {
        return this.getBalance(this.resolvePlayer(identifier));
    }

    public double getBalance(OfflinePlayer player, String worldName) {
        return this.getBalance(player);
    }

    public double getBalance(String identifier, String world) {
        return this.getBalance(this.resolvePlayer(identifier));
    }

    public boolean has(OfflinePlayer player, double amount) {
        try {
            return this.economy.has(player, amount);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning(AnsiColorUtil.danger("VaultEconomyWrapper: Error checking funds for " + player.getName() + ": " + e.getMessage()));
            return false;
        }
    }

    public boolean has(String identifier, double amount) {
        return this.has(this.resolvePlayer(identifier), amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public boolean has(String identifier, String worldName, double amount) {
        return this.has(this.resolvePlayer(identifier), amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        try {
            EconomyResponse internal = this.economy.withdrawPlayer(player, amount);
            return this.convertResponse(internal);
        }
        catch (Exception e) {
            return this.failureResponse(amount, 0.0, "Withdraw error: " + e.getMessage());
        }
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(String identifier, double amount) {
        return this.withdrawPlayer(this.resolvePlayer(identifier), amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(String identifier, String worldName, double amount) {
        return this.withdrawPlayer(this.resolvePlayer(identifier), amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        try {
            EconomyResponse internal = this.economy.depositPlayer(player, amount);
            return this.convertResponse(internal);
        }
        catch (Exception e) {
            return this.failureResponse(amount, 0.0, "Deposit error: " + e.getMessage());
        }
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(String identifier, double amount) {
        return this.depositPlayer(this.resolvePlayer(identifier), amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(String identifier, String worldName, double amount) {
        return this.depositPlayer(this.resolvePlayer(identifier), amount);
    }

    public boolean hasBankSupport() {
        return false;
    }

    public net.milkbowl.vault.economy.EconomyResponse createBank(String name, OfflinePlayer player) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse createBank(String name, String player) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse deleteBank(String name) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse bankBalance(String name) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse bankHas(String name, double amount) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse bankWithdraw(String name, double amount) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse bankDeposit(String name, double amount) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse isBankOwner(String name, String player) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return this.notImplemented();
    }

    public net.milkbowl.vault.economy.EconomyResponse isBankMember(String name, String player) {
        return this.notImplemented();
    }

    public List<String> getBanks() {
        return List.of();
    }

    public int fractionalDigits() {
        return 2;
    }

    public String currencyNamePlural() {
        return "";
    }

    public String currencyNameSingular() {
        return "";
    }

    private OfflinePlayer resolvePlayer(String identifier) {
        try {
            UUID uuid = UUID.fromString(identifier);
            return Bukkit.getOfflinePlayer((UUID)uuid);
        }
        catch (IllegalArgumentException e) {
            return Bukkit.getOfflinePlayer((String)identifier);
        }
    }

    private net.milkbowl.vault.economy.EconomyResponse convertResponse(EconomyResponse internal) {
        EconomyResponse.ResponseType vaultType = switch (internal.type) {
            default -> throw new MatchException(null, null);
            case EconomyResponse.ResponseType.SUCCESS -> EconomyResponse.ResponseType.SUCCESS;
            case EconomyResponse.ResponseType.FAILURE -> EconomyResponse.ResponseType.FAILURE;
            case EconomyResponse.ResponseType.NOT_IMPLEMENTED -> EconomyResponse.ResponseType.NOT_IMPLEMENTED;
        };
        return new net.milkbowl.vault.economy.EconomyResponse(internal.amount, internal.balance, vaultType, internal.errorMessage);
    }

    private net.milkbowl.vault.economy.EconomyResponse notImplemented() {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banking not supported");
    }

    private net.milkbowl.vault.economy.EconomyResponse failureResponse(double amount, double balance, String error) {
        return new net.milkbowl.vault.economy.EconomyResponse(amount, balance, EconomyResponse.ResponseType.FAILURE, error);
    }
}

