/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.vault;

import net.godlycow.org.economy.eco.InternalEconomy;
import net.godlycow.org.economy.vault.VaultEconomyWrapper;
import net.godlycow.org.util.logger.AnsiColorUtil;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class VaultEconomyBridge {
    private final Plugin plugin;
    private final InternalEconomy economy;
    private final String name;

    public VaultEconomyBridge(Plugin plugin, InternalEconomy economy, String name) {
        this.plugin = plugin;
        this.economy = economy;
        this.name = name;
    }

    public void register() {
        try {
            Class<?> rawEconomyClass;
            Class<?> economyClass = rawEconomyClass = Class.forName("net.milkbowl.vault.economy.Economy");
            VaultEconomyWrapper wrapper = new VaultEconomyWrapper(this.economy, this.name);
            this.plugin.getServer().getServicesManager().register(economyClass, (Object)wrapper, this.plugin, ServicePriority.Highest);
            this.plugin.getLogger().info(AnsiColorUtil.success(this.name + " registered with Vault for other plugins!"));
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().warning(AnsiColorUtil.danger("Vault API not found, skipping registration"));
        }
    }
}

