/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.vault;

import java.util.concurrent.CompletableFuture;
import net.godlycow.org.economy.eco.EconomyAPI;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.hooks.VaultHook;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class VaultEconomyAdapter
implements EconomyAPI {
    private final VaultHook vaultHook;

    public VaultEconomyAdapter(VaultHook vaultHook) {
        this.vaultHook = vaultHook;
    }

    @Override
    public boolean isEnabled() {
        return this.vaultHook.isAvailable() && this.vaultHook.hasEconomy();
    }

    @Override
    public String getName() {
        return this.vaultHook.getEconomy().getName();
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        return this.vaultHook.getEconomy().getBalance(player);
    }

    @Override
    public boolean has(OfflinePlayer player, double amount) {
        return this.vaultHook.getEconomy().has(player, amount);
    }

    @Override
    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        net.milkbowl.vault.economy.EconomyResponse vaultResp = this.vaultHook.getEconomy().depositPlayer(player, amount);
        return new EconomyResponse(vaultResp.amount, vaultResp.balance, vaultResp.type == EconomyResponse.ResponseType.SUCCESS ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, vaultResp.errorMessage);
    }

    @Override
    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        net.milkbowl.vault.economy.EconomyResponse vaultResp = this.vaultHook.getEconomy().withdrawPlayer(player, amount);
        return new EconomyResponse(vaultResp.amount, vaultResp.balance, vaultResp.type == EconomyResponse.ResponseType.SUCCESS ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, vaultResp.errorMessage);
    }

    @Override
    public String format(double amount) {
        return this.vaultHook.getEconomy().format(amount);
    }

    @Override
    public boolean createPlayerAccount(OfflinePlayer player) {
        return this.vaultHook.getEconomy().createPlayerAccount(player);
    }

    @Override
    public CompletableFuture<Boolean> hasPaymentsDisabled(String playerUuid) {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Void> setPaymentsDisabled(String playerUuid, String playerName, boolean disabled) {
        return CompletableFuture.completedFuture(null);
    }
}

