/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.shop.gui.trigger;

import java.util.UUID;
import net.godlycow.org.economy.shop.gui.QuantityInventoryHolder;
import net.godlycow.org.economy.shop.gui.ShopGUIManager;
import net.godlycow.org.economy.shop.gui.ShopInventoryHolder;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class ShopGUIListener
implements Listener {
    private final ShopGUIManager guiManager;
    private final Plugin plugin;

    public ShopGUIListener(ShopGUIManager guiManager, Plugin plugin) {
        this.guiManager = guiManager;
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getView().getTopInventory().getHolder() instanceof QuantityInventoryHolder) {
            event.setCancelled(true);
            this.guiManager.getQuantitySelectorGUI().handleClick(player, event.getSlot());
            return;
        }
        if (!(event.getView().getTopInventory().getHolder() instanceof ShopInventoryHolder)) {
            return;
        }
        event.setCancelled(true);
        this.guiManager.handleClick(player, event.getSlot(), event.getClick().name(), event.getInventory());
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inv = event.getInventory();
        if (inv.getHolder() instanceof QuantityInventoryHolder) {
            UUID uuid = player.getUniqueId();
            if (!this.guiManager.getQuantitySelectorGUI().isAwaitingCustomAmount(uuid)) {
                this.guiManager.getQuantitySelectorGUI().cleanupGUI(uuid);
            }
            return;
        }
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            UUID playerId = player.getUniqueId();
            boolean inQuantityGUI = this.guiManager.getQuantitySelectorGUI().isGUIOpen(playerId);
            boolean inShopGUI = this.guiManager.isShopGUIOpen(playerId);
            if (!inQuantityGUI && !inShopGUI) {
                this.guiManager.cleanupPlayer(playerId);
            }
        }, 2L);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.guiManager.getQuantitySelectorGUI().isAwaitingCustomAmount(player.getUniqueId())) {
            event.setCancelled(true);
            this.guiManager.getQuantitySelectorGUI().handleChatInput(player, event.getMessage());
        }
    }
}

