/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.shop.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.commands.config.ShopConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.economy.shop.ShopDataManager;
import net.godlycow.org.economy.shop.config.MainShopConfig;
import net.godlycow.org.economy.shop.config.ShopSectionConfig;
import net.godlycow.org.economy.shop.gui.QuantitySelectorGUI;
import net.godlycow.org.economy.shop.gui.ShopInventoryHolder;
import net.godlycow.org.economy.shop.storage.ShopStorage;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class ShopGUIManager {
    private static final MiniMessage mini = MiniMessage.miniMessage();
    private static final long CLICK_COOLDOWN_MS = 200L;
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final ShopStorage storage;
    private final ShopConfig config;
    private final EconomyManager economyManager;
    private final ShopDataManager dataManager;
    private final Map<String, ShopSectionConfig> sectionCache = new ConcurrentHashMap<String, ShopSectionConfig>();
    private MainShopConfig mainConfigCache;
    private boolean configsLoaded = false;
    private final Map<UUID, String> openSection = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Integer> currentPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> clickCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Set<UUID> mainGUIOpen = ConcurrentHashMap.newKeySet();
    private final QuantitySelectorGUI quantitySelectorGUI;

    public ShopGUIManager(Plugin plugin, PlayerLanguageManager langManager, ShopStorage storage, ShopConfig config, EconomyManager economyManager, ShopDataManager dataManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.economyManager = economyManager;
        this.dataManager = dataManager;
        this.quantitySelectorGUI = new QuantitySelectorGUI(plugin, langManager, economyManager, this);
        this.loadAllConfigs(false);
        if (!economyManager.isEnabled()) {
            plugin.getLogger().warning("ShopGUIManager: Economy disabled! Shop will be view-only.");
        }
    }

    private void loadAllConfigs() {
        this.loadAllConfigs(false);
    }

    private void loadAllConfigs(boolean forceFromFiles) {
        File shopFolder = this.config.getShopFolder();
        if (!shopFolder.exists() || !shopFolder.isDirectory()) {
            this.plugin.getLogger().warning("Shop folder not found at: " + shopFolder.getPath());
            this.mainConfigCache = new MainShopConfig();
            this.configsLoaded = true;
            return;
        }
        this.loadMainConfigSmart(forceFromFiles);
        this.loadSectionConfigsSmart(forceFromFiles);
        this.configsLoaded = true;
        this.plugin.getLogger().info("\u2713 Shop configurations loaded successfully");
    }

    private void loadMainConfigSmart(boolean forceFromFiles) {
        boolean shouldLoadFromFile;
        File mainFile = new File(this.config.getShopFolder(), "main.yml");
        long fileModified = mainFile.exists() ? mainFile.lastModified() : 0L;
        long dbUpdated = this.dataManager.getMainConfigLastUpdate().join();
        boolean bl = shouldLoadFromFile = forceFromFiles || fileModified > dbUpdated && fileModified > 0L || dbUpdated == 0L;
        if (shouldLoadFromFile && mainFile.exists()) {
            this.mainConfigCache = this.loadMainConfigFromFileInternal(mainFile);
            if (this.isValidMainConfig(this.mainConfigCache)) {
                this.dataManager.saveMainConfig(this.mainConfigCache);
                this.plugin.getLogger().info("\u2713 Loaded main shop config from file (newer than DB)");
            } else {
                this.plugin.getLogger().severe("Loaded main config from file but it's invalid! Using DB fallback.");
                this.fallbackToDBMain();
            }
        } else if (dbUpdated > 0L) {
            this.fallbackToDBMain();
        } else {
            this.plugin.getLogger().warning("No main shop config found in files or database. Using defaults.");
            this.mainConfigCache = new MainShopConfig();
        }
    }

    private void fallbackToDBMain() {
        MainShopConfig dbConfig = this.dataManager.loadMainConfig().join();
        if (this.isValidMainConfig(dbConfig)) {
            this.mainConfigCache = dbConfig;
            this.plugin.getLogger().info("\u2713 Loaded main shop config from database");
        } else {
            this.plugin.getLogger().severe("Database main config is invalid! Creating new default.");
            this.mainConfigCache = new MainShopConfig();
        }
    }

    private void loadSectionConfigsSmart(boolean forceFromFiles) {
        File shopFolder = this.config.getShopFolder();
        File[] files = shopFolder.listFiles((d, name) -> name.endsWith(".yml") && !name.equals("main.yml"));
        if (files == null || files.length == 0) {
            this.plugin.getLogger().info("No section config files found.");
            return;
        }
        HashSet<String> processedSections = new HashSet<String>();
        for (File file : files) {
            String name2 = file.getName().replace(".yml", "");
            processedSections.add(name2);
            this.loadSingleSectionSmart(name2, forceFromFiles);
        }
        this.sectionCache.keySet().retainAll(processedSections);
    }

    private void loadSingleSectionSmart(String sectionName, boolean forceFromFiles) {
        boolean shouldLoadFromFile;
        File sectionFile = new File(this.config.getShopFolder(), sectionName + ".yml");
        if (!sectionFile.exists()) {
            this.sectionCache.remove(sectionName);
            return;
        }
        long fileModified = sectionFile.lastModified();
        long dbUpdated = this.dataManager.getSectionLastUpdate(sectionName).join();
        boolean bl = shouldLoadFromFile = forceFromFiles || fileModified > dbUpdated && fileModified > 0L || dbUpdated == 0L;
        if (shouldLoadFromFile) {
            ShopSectionConfig section = this.loadSectionConfigFromFileInternal(sectionFile);
            if (this.isValidSectionConfig(section)) {
                this.sectionCache.put(sectionName, section);
                this.dataManager.saveSectionConfig(sectionName, section);
            } else {
                this.plugin.getLogger().severe("Section '" + sectionName + "' loaded from file is invalid! Using DB fallback.");
                this.fallbackToDBSection(sectionName);
            }
        } else if (dbUpdated > 0L) {
            this.fallbackToDBSection(sectionName);
        }
    }

    private void fallbackToDBSection(String sectionName) {
        ShopSectionConfig dbSection = this.dataManager.loadSectionConfig(sectionName).join();
        if (this.isValidSectionConfig(dbSection)) {
            this.sectionCache.put(sectionName, dbSection);
        } else {
            this.plugin.getLogger().warning("Section '" + sectionName + "' not found in database. Skipping.");
            this.sectionCache.remove(sectionName);
        }
    }

    private MainShopConfig loadMainConfigFromFileInternal(File file) {
        int slot;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        MainShopConfig main = new MainShopConfig();
        main.title = config.getString("title", "Shop");
        main.size = config.getInt("size", 54);
        if (config.isConfigurationSection("layout")) {
            for (String key : config.getConfigurationSection("layout").getKeys(false)) {
                slot = Integer.parseInt(key);
                MainShopConfig.LayoutItem item = new MainShopConfig.LayoutItem();
                item.material = Material.valueOf((String)config.getString("layout." + key + ".material", "STONE"));
                item.name = config.getString("layout." + key + ".name", "");
                item.clickable = config.getBoolean("layout." + key + ".clickable", false);
                main.layout.put(slot, item);
            }
        }
        if (config.isConfigurationSection("sections")) {
            for (String key : config.getConfigurationSection("sections").getKeys(false)) {
                slot = Integer.parseInt(key);
                MainShopConfig.SectionButton button = new MainShopConfig.SectionButton();
                button.material = Material.valueOf((String)config.getString("sections." + key + ".material", "STONE"));
                button.name = config.getString("sections." + key + ".name", "");
                button.lore = config.getStringList("sections." + key + ".lore");
                button.file = config.getString("sections." + key + ".file");
                main.sectionButtons.put(slot, button);
            }
        }
        return main;
    }

    private ShopSectionConfig loadSectionConfigFromFileInternal(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ShopSectionConfig section = new ShopSectionConfig();
        section.title = config.getString("title", "Shop Section");
        section.size = config.getInt("size", 54);
        section.pages = config.getInt("pages", 1);
        section.playerHeadSlot = config.getInt("player-head-slot", -1);
        section.closeButtonSlot = config.getInt("close-button-slot", -1);
        if (config.isConfigurationSection("layout")) {
            config.getConfigurationSection("layout").getKeys(false).forEach(key -> {
                int slot = Integer.parseInt(key);
                ShopSectionConfig.LayoutItem item = new ShopSectionConfig.LayoutItem();
                item.material = Material.valueOf((String)config.getString("layout." + key + ".material", "STONE"));
                item.name = config.getString("layout." + key + ".name", "");
                item.lore = config.getStringList("layout." + key + ".lore");
                item.clickable = config.getBoolean("layout." + key + ".clickable", false);
                section.layout.put(slot, item);
            });
        }
        if (config.isConfigurationSection("items")) {
            ConfigurationSection itemsSection = config.getConfigurationSection("items");
            for (String key2 : itemsSection.getKeys(false)) {
                ConfigurationSection itemSec = itemsSection.getConfigurationSection(key2);
                if (itemSec == null) continue;
                ShopSectionConfig.ShopItem item = new ShopSectionConfig.ShopItem();
                item.material = Material.matchMaterial((String)itemSec.getString("material", "STONE"));
                item.amount = itemSec.getInt("amount", 1);
                item.name = itemSec.getString("name", "");
                item.lore = itemSec.getStringList("lore");
                item.slot = itemSec.getInt("slot", -1);
                item.page = itemSec.getInt("page", 1);
                item.buyPrice = itemSec.getDouble("buy-price", -1.0);
                item.sellPrice = itemSec.getDouble("sell-price", -1.0);
                item.customItemId = itemSec.getString("custom-item-id", null);
                item.clickable = itemSec.getBoolean("clickable", true);
                section.items.put(key2, item);
            }
        }
        return section;
    }

    private boolean isValidMainConfig(MainShopConfig config) {
        return config != null && config.size > 0 && config.layout != null && config.sectionButtons != null && config.title != null;
    }

    private boolean isValidSectionConfig(ShopSectionConfig config) {
        return config != null && config.size > 0 && config.layout != null && config.items != null && config.title != null;
    }

    public void openMainGUI(Player player) {
        ItemStack stack;
        int slot;
        if (!this.configsLoaded) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.loading", "<yellow>Loading shop...", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        if (this.mainConfigCache == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-main-config", "<red>Shop configuration not found. Please contact an administrator.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        Component title = this.langManager.getMessageFor(player, "commands.economy.shop.main-title", this.mainConfigCache.title != null ? this.mainConfigCache.title : "<green>Main Shop", new LanguageManager.ComponentPlaceholder[0]);
        ShopInventoryHolder holder = new ShopInventoryHolder(this, true);
        Inventory inv = Bukkit.createInventory((InventoryHolder)holder, (int)this.config.mainSize, (Component)title);
        for (Map.Entry<Integer, MainShopConfig.LayoutItem> entry : this.mainConfigCache.layout.entrySet()) {
            slot = entry.getKey();
            MainShopConfig.LayoutItem item = entry.getValue();
            stack = this.createItem(item.material, item.name, null, 1);
            inv.setItem(slot, stack);
        }
        for (Map.Entry<Integer, Object> entry : this.mainConfigCache.sectionButtons.entrySet()) {
            slot = entry.getKey();
            MainShopConfig.SectionButton button = (MainShopConfig.SectionButton)entry.getValue();
            stack = this.createItem(button.material, button.name, button.lore, 1);
            inv.setItem(slot, stack);
        }
        ItemStack close = this.createItem(Material.BARRIER, "<red>Close", null, 1);
        inv.setItem(this.config.closeButtonSlot, close);
        player.openInventory(inv);
        this.openSection.remove(player.getUniqueId());
        this.mainGUIOpen.add(player.getUniqueId());
    }

    public void openSectionGUI(Player player, String fileName, int page) {
        int closeSlot;
        int headSlot;
        if (!this.configsLoaded) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.loading", "<yellow>Loading shop...", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        ShopSectionConfig section = this.sectionCache.get(fileName);
        if (section == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-section", "<red>Shop section not found: <white>{section}", LanguageManager.ComponentPlaceholder.of("{section}", fileName)));
            return;
        }
        String displayTitle = section.title != null ? section.title : fileName.replace(".yml", "").replace("-", " ");
        Component title = this.langManager.getMessageFor(player, "commands.economy.shop.section-title", "<green>{section} Shop", LanguageManager.ComponentPlaceholder.of("{section}", displayTitle));
        ShopInventoryHolder holder = new ShopInventoryHolder(this, false);
        Inventory inv = Bukkit.createInventory((InventoryHolder)holder, (int)section.size, (Component)title);
        for (Map.Entry<Integer, ShopSectionConfig.LayoutItem> entry : section.layout.entrySet()) {
            int slot = entry.getKey();
            ShopSectionConfig.LayoutItem item2 = entry.getValue();
            ItemStack stack = this.createItem(item2.material, item2.name, item2.lore, 1);
            inv.setItem(slot, stack);
        }
        section.items.values().stream().filter(item -> item.page == page).forEach(item -> {
            ItemStack stack = this.createItem(item.material, item.name, item.lore, item.amount);
            if (this.economyManager.isEnabled()) {
                ArrayList<String> itemLore = new ArrayList<String>(item.lore != null ? item.lore : new ArrayList());
                stack = this.createItem(item.material, item.name, itemLore, item.amount);
            } else {
                ArrayList<String> disabledLore = new ArrayList<String>();
                disabledLore.add("<red>\u2717 Economy not available");
                disabledLore.add("<gray>Shop is view-only");
                stack = this.createItem(item.material, item.name, disabledLore, item.amount);
            }
            inv.setItem(item.slot, stack);
        });
        int n = headSlot = section.playerHeadSlot >= 0 ? section.playerHeadSlot : this.config.playerHeadSlot;
        if (headSlot >= 0) {
            ItemStack skull = this.createPlayerHead(player);
            inv.setItem(headSlot, skull);
        }
        int n2 = closeSlot = section.closeButtonSlot >= 0 ? section.closeButtonSlot : this.config.closeButtonSlot;
        if (closeSlot >= 0) {
            ItemStack back = this.createItem(Material.BARRIER, "<red>Back", null, 1);
            inv.setItem(closeSlot, back);
        }
        if (page > 1) {
            ItemStack prev = this.createItem(Material.ARROW, "<gray>Previous Page", null, 1);
            inv.setItem(45, prev);
        }
        if (page < section.pages) {
            ItemStack next = this.createItem(Material.ARROW, "<gray>Next Page", null, 1);
            inv.setItem(53, next);
        }
        player.openInventory(inv);
        this.openSection.put(player.getUniqueId(), fileName);
        this.currentPage.put(player.getUniqueId(), page);
        this.mainGUIOpen.remove(player.getUniqueId());
        this.storage.setPlayerSection(player.getUniqueId(), fileName);
        this.storage.setPlayerPage(player.getUniqueId(), page);
    }

    public void handleClick(Player player, int slot, String clickType, Inventory inv) {
        boolean isMain;
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.clickCooldowns.getOrDefault(uuid, 0L) > currentTime) {
            return;
        }
        this.clickCooldowns.put(uuid, currentTime + 200L);
        String sectionFile = this.openSection.get(uuid);
        boolean bl = isMain = sectionFile == null;
        if (isMain) {
            this.handleMainMenuClick(player, slot);
        } else {
            int page = this.currentPage.getOrDefault(uuid, 1);
            this.handleSectionClick(player, slot, page, sectionFile, clickType);
        }
    }

    private void handleMainMenuClick(Player player, int slot) {
        if (this.mainConfigCache == null) {
            return;
        }
        if (slot == this.config.closeButtonSlot) {
            player.closeInventory();
            return;
        }
        MainShopConfig.SectionButton button = this.mainConfigCache.sectionButtons.get(slot);
        if (button != null) {
            String sectionFileName = button.file.replace(".yml", "");
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, sectionFileName, 1));
        }
    }

    private void handleSectionClick(Player player, int slot, int page, String sectionFile, String clickType) {
        int closeSlot;
        ShopSectionConfig section = this.sectionCache.get(sectionFile);
        if (section == null) {
            return;
        }
        if (slot == 45 && page > 1) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, sectionFile, page - 1));
            return;
        }
        if (slot == 53 && page < section.pages) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, sectionFile, page + 1));
            return;
        }
        int n = closeSlot = section.closeButtonSlot >= 0 ? section.closeButtonSlot : this.config.closeButtonSlot;
        if (slot == closeSlot) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
            return;
        }
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-economy", "<red>\u2717 Economy system is not available. Shop is view-only.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        for (ShopSectionConfig.ShopItem item : section.items.values()) {
            if (item.page != page || item.slot != slot || !item.clickable) continue;
            boolean isLeftClick = clickType.equals("LEFT");
            boolean isRightClick = clickType.equals("RIGHT");
            if (isLeftClick && item.buyPrice > 0.0) {
                this.quantitySelectorGUI.open(player, item, sectionFile, page);
                return;
            }
            if (!isRightClick || !(item.sellPrice > 0.0) || !this.config.enableSell) break;
            this.handleSell(player, item);
            break;
        }
    }

    private void handleBuy(Player player, ShopSectionConfig.ShopItem item) {
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        double totalBuyPrice = item.buyPrice * (double)item.amount;
        double balance = this.economyManager.getBalance(player);
        if (balance >= totalBuyPrice) {
            EconomyResponse response = this.economyManager.withdraw(player, totalBuyPrice);
            if (response.success()) {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(item.material, item.amount)});
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.buy-success", "<green>\u2713 You bought {amount}x {item} for {price}", LanguageManager.ComponentPlaceholder.of("{amount}", item.amount), LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(totalBuyPrice))));
                this.refreshGUI(player);
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.transaction-failed", "<red>\u2717 Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", response.errorMessage)));
            }
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.cannot-afford", "<red>\u2717 You cannot afford {item} (cost: {price})", LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(totalBuyPrice))));
        }
    }

    private void handleSell(Player player, ShopSectionConfig.ShopItem item) {
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-economy", "<red>\u2717 Economy system is not available.", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        if (!player.getInventory().containsAtLeast(new ItemStack(item.material), item.amount)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-items", "<red>\u2717 You don't have enough {item} to sell", LanguageManager.ComponentPlaceholder.of("{item}", item.name)));
            return;
        }
        double totalSellPrice = item.sellPrice * (double)item.amount;
        this.removeItems(player, item.material, item.amount);
        EconomyResponse response = this.economyManager.deposit(player, totalSellPrice);
        if (response.success()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.sell-success", "<green>\u2713 You sold {amount}x {item} for {price}", LanguageManager.ComponentPlaceholder.of("{amount}", item.amount), LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(totalSellPrice))));
            this.refreshGUI(player);
        } else {
            player.getInventory().addItem(new ItemStack[]{new ItemStack(item.material, item.amount)});
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.transaction-failed", "<red>\u2717 Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", response.errorMessage)));
        }
    }

    private void refreshGUI(Player player) {
        String section = this.openSection.get(player.getUniqueId());
        int page = this.currentPage.getOrDefault(player.getUniqueId(), 1);
        if (section != null) {
            Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, section, page));
        }
    }

    public void refreshOpenInventories() {
        new HashSet<UUID>(this.openSection.keySet()).forEach(uuid -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null && player.getOpenInventory().getTopInventory().getHolder() == null) {
                String section = this.openSection.get(uuid);
                int page = this.currentPage.getOrDefault(uuid, 1);
                if (section == null) {
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openMainGUI(player));
                } else {
                    Bukkit.getScheduler().runTask(this.plugin, () -> this.openSectionGUI(player, section, page));
                }
            }
        });
    }

    public boolean isShopGUIOpen(UUID playerUuid) {
        return this.mainGUIOpen.contains(playerUuid) || this.openSection.containsKey(playerUuid);
    }

    public void cleanupPlayer(UUID playerUuid) {
        this.openSection.remove(playerUuid);
        this.currentPage.remove(playerUuid);
        this.mainGUIOpen.remove(playerUuid);
        this.clickCooldowns.remove(playerUuid);
    }

    private void removeItems(Player player, Material material, int amount) {
        int remaining = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() != material) continue;
            int stackAmount = stack.getAmount();
            if (stackAmount <= remaining) {
                player.getInventory().clear(i);
                remaining -= stackAmount;
            } else {
                stack.setAmount(stackAmount - remaining);
                remaining = 0;
            }
            if (remaining <= 0) break;
        }
        player.updateInventory();
    }

    private ItemStack createItem(Material material, String name, List<String> lore, int amount) {
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (name != null) {
                meta.displayName(mini.deserialize(name));
            }
            if (lore != null) {
                List<Component> loreComponents = lore.stream().map(line -> mini.deserialize(line)).toList();
                meta.lore(loreComponents);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public void reloadConfigs(boolean forceFromFiles) {
        this.plugin.getLogger().info("Reloading shop configurations...");
        this.sectionCache.clear();
        this.mainConfigCache = null;
        this.configsLoaded = false;
        this.loadAllConfigs(forceFromFiles);
        if (forceFromFiles) {
            this.refreshOpenInventories();
        }
        this.plugin.getLogger().info("\u2713 Reload complete (source: " + (forceFromFiles ? "forced from files)" : "smart load)"));
    }

    private ItemStack createPlayerHead(Player player) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
            String balanceText = this.economyManager.isEnabled() ? this.economyManager.format(this.economyManager.getBalance(player)) : "N/A";
            meta.displayName(this.langManager.getMessageFor(player, "commands.economy.shop.balance-display", "<green>Your Balance: <gold>{balance}", LanguageManager.ComponentPlaceholder.of("{balance}", balanceText)));
            if (!this.economyManager.isEnabled()) {
                ArrayList lore = new ArrayList();
                lore.add(mini.deserialize("<red>\u2717 Economy disabled"));
                meta.lore(lore);
            }
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public MainShopConfig getMainConfig() {
        return this.mainConfigCache;
    }

    public ShopSectionConfig getSectionConfig(String name) {
        return this.sectionCache.get(name);
    }

    public Map<String, ShopSectionConfig> getSectionCache() {
        return new HashMap<String, ShopSectionConfig>(this.sectionCache);
    }

    public QuantitySelectorGUI getQuantitySelectorGUI() {
        return this.quantitySelectorGUI;
    }

    public String getPlayerSection(UUID playerUuid) {
        return this.openSection.get(playerUuid);
    }

    public int getPlayerPage(UUID playerUuid) {
        return this.currentPage.getOrDefault(playerUuid, 1);
    }
}

