/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.shop.gui;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.economy.shop.config.ShopSectionConfig;
import net.godlycow.org.economy.shop.gui.QuantityInventoryHolder;
import net.godlycow.org.economy.shop.gui.ShopGUIManager;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class QuantitySelectorGUI {
    private static final MiniMessage mini = MiniMessage.miniMessage();
    private static final int INVENTORY_SIZE = 27;
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final EconomyManager economyManager;
    private final ShopGUIManager shopGUIManager;
    private final Map<UUID, State> playerState = new ConcurrentHashMap<UUID, State>();

    public QuantitySelectorGUI(Plugin plugin, PlayerLanguageManager langManager, EconomyManager economyManager, ShopGUIManager shopGUIManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.economyManager = economyManager;
        this.shopGUIManager = shopGUIManager;
    }

    public void open(Player player, ShopSectionConfig.ShopItem shopItem, String sectionFile, int page) {
        State state = new State(sectionFile, page, shopItem);
        this.playerState.put(player.getUniqueId(), state);
        Inventory inv = this.createInventory(player, shopItem, 0);
        player.openInventory(inv);
    }

    public boolean isGUIOpen(UUID playerUuid) {
        return this.playerState.containsKey(playerUuid);
    }

    public boolean isAwaitingCustomAmount(UUID playerUuid) {
        State state = this.playerState.get(playerUuid);
        return state != null && state.awaitingCustomAmount;
    }

    public void cleanupGUI(UUID playerUuid) {
        this.playerState.remove(playerUuid);
    }

    public void cleanupChat(UUID playerUuid) {
        State state = this.playerState.remove(playerUuid);
        if (state != null) {
            state.awaitingCustomAmount = false;
        }
    }

    public void handleChatInput(Player player, String message) {
        State state = this.playerState.get(player.getUniqueId());
        if (state == null || !state.awaitingCustomAmount) {
            return;
        }
        state.awaitingCustomAmount = false;
        if (message.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.cancelled", "<red>\u2717 Purchase cancelled", new LanguageManager.ComponentPlaceholder[0]));
            this.cleanupChat(player.getUniqueId());
            Bukkit.getScheduler().runTask(this.plugin, () -> this.shopGUIManager.openSectionGUI(player, state.sectionFile, state.page));
            return;
        }
        try {
            int customAmount = Integer.parseInt(message);
            if (customAmount <= 0) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.negative-amount", "<red>\u2717 Amount must be greater than 0", new LanguageManager.ComponentPlaceholder[0]));
            } else {
                state.quantity = customAmount;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.invalid-amount", "<red>\u2717 Invalid amount. Please enter a number.", new LanguageManager.ComponentPlaceholder[0]));
        }
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Inventory inv = this.createInventory(player, state.shopItem, state.quantity);
            player.openInventory(inv);
        });
    }

    private Inventory createInventory(Player player, ShopSectionConfig.ShopItem shopItem, int quantity) {
        Component title = this.langManager.getMessageFor(player, "commands.economy.shop.quantity-title", "<gold>Select Quantity: <gray>{item}", LanguageManager.ComponentPlaceholder.of("{item}", shopItem.name));
        Inventory inv = Bukkit.createInventory((InventoryHolder)new QuantityInventoryHolder(), (int)27, (Component)title);
        inv.setItem(4, this.createPlayerHead(player));
        inv.setItem(13, this.createItemDisplay(shopItem, quantity));
        inv.setItem(9, this.createQuantityButton(Material.RED_CONCRETE, "<red>-64", -64));
        inv.setItem(10, this.createQuantityButton(Material.RED_CONCRETE, "<red>-10", -10));
        inv.setItem(11, this.createQuantityButton(Material.RED_CONCRETE, "<red>-1", -1));
        inv.setItem(15, this.createQuantityButton(Material.LIME_CONCRETE, "<green>+1", 1));
        inv.setItem(16, this.createQuantityButton(Material.LIME_CONCRETE, "<green>+10", 10));
        inv.setItem(17, this.createQuantityButton(Material.LIME_CONCRETE, "<green>+64", 64));
        inv.setItem(18, this.createControlButton(Material.REDSTONE_BLOCK, "<red>\u2717 Cancel"));
        inv.setItem(22, this.createControlButton(Material.SEA_LANTERN, "<yellow>\ud83d\udd22 Custom Amount"));
        inv.setItem(26, this.createControlButton(Material.EMERALD_BLOCK, "<green>\u2713 Confirm"));
        return inv;
    }

    private ItemStack createPlayerHead(Player player) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
            String balanceText = this.economyManager.isEnabled() ? this.economyManager.format(this.economyManager.getBalance(player)) : "N/A";
            meta.displayName(this.langManager.getMessageFor(player, "commands.economy.shop.balance-display", "<green>Your Balance: <gold>{balance}", LanguageManager.ComponentPlaceholder.of("{balance}", balanceText)));
            ArrayList lore = new ArrayList();
            State state = this.playerState.get(player.getUniqueId());
            if (state != null) {
                double totalPrice = state.shopItem.buyPrice * (double)state.quantity;
                lore.add(mini.deserialize("<gray>Total cost: <gold>" + this.economyManager.format(totalPrice)));
            }
            if (!this.economyManager.isEnabled()) {
                lore.add(mini.deserialize("<red>\u2717 Economy disabled"));
            }
            meta.lore(lore);
            skull.setItemMeta((ItemMeta)meta);
        }
        return skull;
    }

    private ItemStack createItemDisplay(ShopSectionConfig.ShopItem shopItem, int quantity) {
        ItemStack item = new ItemStack(shopItem.material, quantity > 0 ? quantity : 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(mini.deserialize(shopItem.name));
            ArrayList lore = new ArrayList();
            if (shopItem.lore != null) {
                shopItem.lore.forEach(line -> lore.add(mini.deserialize(line)));
            }
            lore.add(mini.deserialize("<dark_gray>-------------------"));
            lore.add(mini.deserialize("<gray>Quantity: <yellow>" + quantity));
            double totalPrice = shopItem.buyPrice * (double)quantity;
            lore.add(mini.deserialize("<gray>Total: <gold>" + this.economyManager.format(totalPrice)));
            if (shopItem.buyPrice > 0.0) {
                lore.add(mini.deserialize("<gray>Unit price: <gold>" + this.economyManager.format(shopItem.buyPrice)));
            }
            meta.lore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createQuantityButton(Material material, String label, int change) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(mini.deserialize(label));
            ArrayList lore = new ArrayList();
            lore.add(mini.deserialize("<gray>Click to adjust"));
            meta.lore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createControlButton(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(mini.deserialize(name));
            item.setItemMeta(meta);
        }
        return item;
    }

    public void handleClick(Player player, int slot) {
        State state = this.playerState.get(player.getUniqueId());
        if (state == null) {
            this.plugin.getLogger().warning("QuantitySelectorGUI: No state found for " + player.getName());
            return;
        }
        this.plugin.getLogger().info("QuantitySelectorGUI: Player " + player.getName() + " clicked slot " + slot);
        if (slot == 9) {
            this.adjustQuantity(player, -64);
        } else if (slot == 10) {
            this.adjustQuantity(player, -10);
        } else if (slot == 11) {
            this.adjustQuantity(player, -1);
        } else if (slot == 15) {
            this.adjustQuantity(player, 1);
        } else if (slot == 16) {
            this.adjustQuantity(player, 10);
        } else if (slot == 17) {
            this.adjustQuantity(player, 64);
        } else if (slot == 18) {
            this.cancel(player);
        } else if (slot == 22) {
            this.promptCustomAmount(player);
        } else if (slot == 26) {
            this.confirm(player);
        } else {
            this.plugin.getLogger().warning("QuantitySelectorGUI: Unexpected slot " + slot + " clicked by " + player.getName());
        }
    }

    private void adjustQuantity(Player player, int change) {
        int newQuantity;
        State state = this.playerState.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        state.quantity = newQuantity = Math.max(0, state.quantity + change);
        Inventory inv = player.getOpenInventory().getTopInventory();
        inv.setItem(13, this.createItemDisplay(state.shopItem, newQuantity));
        inv.setItem(4, this.createPlayerHead(player));
    }

    private void promptCustomAmount(Player player) {
        State state = this.playerState.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        state.awaitingCustomAmount = true;
        player.closeInventory();
        player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.custom-amount-prompt", "<yellow>Please type the amount you want to buy in chat, or type <red>cancel<yellow> to exit.", new LanguageManager.ComponentPlaceholder[0]));
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            State st = this.playerState.get(player.getUniqueId());
            if (st != null && st.awaitingCustomAmount) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.custom-amount-timeout", "<red>\u2717 Custom amount input timed out.", new LanguageManager.ComponentPlaceholder[0]));
                this.cleanupChat(player.getUniqueId());
            }
        }, 1200L);
    }

    private void cancel(Player player) {
        State state = this.playerState.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        this.cleanupGUI(player.getUniqueId());
        player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.cancelled", "<red>\u2717 Purchase cancelled", new LanguageManager.ComponentPlaceholder[0]));
        Bukkit.getScheduler().runTask(this.plugin, () -> this.shopGUIManager.openSectionGUI(player, state.sectionFile, state.page));
    }

    private void confirm(Player player) {
        State state = this.playerState.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        if (state.quantity <= 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.zero-quantity", "<red>\u2717 Please select a quantity greater than 0", new LanguageManager.ComponentPlaceholder[0]));
            return;
        }
        ShopSectionConfig.ShopItem item = state.shopItem;
        double totalPrice = item.buyPrice * (double)state.quantity;
        double balance = this.economyManager.getBalance(player);
        if (balance < totalPrice) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.cannot-afford-bulk", "<red>\u2717 You cannot afford {quantity}x {item} (cost: {price})", LanguageManager.ComponentPlaceholder.of("{quantity}", state.quantity), LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(totalPrice))));
            this.cleanupGUI(player.getUniqueId());
            Bukkit.getScheduler().runTask(this.plugin, () -> this.shopGUIManager.openSectionGUI(player, state.sectionFile, state.page));
            return;
        }
        int totalItems = state.quantity * item.amount;
        if (player.getInventory().firstEmpty() == -1 && !player.getInventory().contains(item.material)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-inventory-space", "<red>\u2717 You don't have enough inventory space for {quantity}x {item}", LanguageManager.ComponentPlaceholder.of("{quantity}", state.quantity), LanguageManager.ComponentPlaceholder.of("{item}", item.name)));
            return;
        }
        EconomyResponse response = this.economyManager.withdraw(player, totalPrice);
        if (response.success()) {
            ItemStack giveItem = new ItemStack(item.material, totalItems);
            player.getInventory().addItem(new ItemStack[]{giveItem});
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.bulk-buy-success", "<green>\u2713 You bought {quantity}x {item} for {price}", LanguageManager.ComponentPlaceholder.of("{quantity}", state.quantity), LanguageManager.ComponentPlaceholder.of("{item}", item.name), LanguageManager.ComponentPlaceholder.of("{price}", this.economyManager.format(totalPrice))));
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                this.cleanupGUI(player.getUniqueId());
                this.shopGUIManager.openSectionGUI(player, state.sectionFile, state.page);
            });
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.transaction-failed", "<red>\u2717 Transaction failed: {error}", LanguageManager.ComponentPlaceholder.of("{error}", response.errorMessage)));
        }
    }

    public static class State {
        public final String sectionFile;
        public final int page;
        public final ShopSectionConfig.ShopItem shopItem;
        public int quantity;
        public boolean awaitingCustomAmount = false;

        State(String sectionFile, int page, ShopSectionConfig.ShopItem shopItem) {
            this.sectionFile = sectionFile;
            this.page = page;
            this.shopItem = shopItem;
            this.quantity = 0;
        }
    }
}

