/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.shop.config.loader;

import com.google.gson.Gson;
import java.io.File;
import net.godlycow.org.economy.shop.ShopDataManager;
import net.godlycow.org.economy.shop.config.MainShopConfig;
import net.godlycow.org.economy.shop.config.ShopSectionConfig;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ShopConfigLoader {
    private static final Gson gson = new Gson();

    public static MainShopConfig loadMainConfig(File file, ShopDataManager dataManager) {
        MainShopConfig dbConfig = dataManager.loadMainConfig().join();
        if (dbConfig != null && ShopConfigLoader.isValidMainConfig(dbConfig)) {
            return dbConfig;
        }
        if (!file.exists()) {
            System.err.println("No main.yml found. Using defaults.");
            return new MainShopConfig();
        }
        System.out.println("Loading main config from file (DB empty)");
        return ShopConfigLoader.loadMainConfigFromFileInternal(file);
    }

    public static ShopSectionConfig loadSectionConfig(File file, String sectionName, ShopDataManager dataManager) {
        ShopSectionConfig dbConfig = dataManager.loadSectionConfig(sectionName).join();
        if (dbConfig != null && ShopConfigLoader.isValidSectionConfig(dbConfig)) {
            return dbConfig;
        }
        if (!file.exists()) {
            System.err.println("Section file not found: " + file.getName());
            return new ShopSectionConfig();
        }
        System.out.println("Loading section '" + sectionName + "' from file (DB empty)");
        return ShopConfigLoader.loadSectionConfigFromFileInternal(file);
    }

    private static MainShopConfig loadMainConfigFromFileInternal(File file) {
        int slot;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        MainShopConfig main = new MainShopConfig();
        main.title = config.getString("title", "Shop");
        main.size = config.getInt("size", 54);
        if (config.isConfigurationSection("layout")) {
            for (String key : config.getConfigurationSection("layout").getKeys(false)) {
                slot = Integer.parseInt(key);
                MainShopConfig.LayoutItem item = new MainShopConfig.LayoutItem();
                item.material = Material.valueOf((String)config.getString("layout." + key + ".material", "STONE"));
                item.name = config.getString("layout." + key + ".name", "");
                item.clickable = config.getBoolean("layout." + key + ".clickable", false);
                main.layout.put(slot, item);
            }
        }
        if (config.isConfigurationSection("sections")) {
            for (String key : config.getConfigurationSection("sections").getKeys(false)) {
                slot = Integer.parseInt(key);
                MainShopConfig.SectionButton button = new MainShopConfig.SectionButton();
                button.material = Material.valueOf((String)config.getString("sections." + key + ".material", "STONE"));
                button.name = config.getString("sections." + key + ".name", "");
                button.lore = config.getStringList("sections." + key + ".lore");
                button.file = config.getString("sections." + key + ".file");
                main.sectionButtons.put(slot, button);
            }
        }
        return main;
    }

    private static ShopSectionConfig loadSectionConfigFromFileInternal(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        ShopSectionConfig section = new ShopSectionConfig();
        section.title = config.getString("title", "Shop Section");
        section.size = config.getInt("size", 54);
        section.pages = config.getInt("pages", 1);
        section.playerHeadSlot = config.getInt("player-head-slot", -1);
        section.closeButtonSlot = config.getInt("close-button-slot", -1);
        if (config.isConfigurationSection("layout")) {
            config.getConfigurationSection("layout").getKeys(false).forEach(key -> {
                int slot = Integer.parseInt(key);
                ShopSectionConfig.LayoutItem item = new ShopSectionConfig.LayoutItem();
                item.material = Material.valueOf((String)config.getString("layout." + key + ".material", "STONE"));
                item.name = config.getString("layout." + key + ".name", "");
                item.lore = config.getStringList("layout." + key + ".lore");
                item.clickable = config.getBoolean("layout." + key + ".clickable", false);
                section.layout.put(slot, item);
            });
        }
        if (config.isConfigurationSection("items")) {
            ConfigurationSection itemsSection = config.getConfigurationSection("items");
            for (String key2 : itemsSection.getKeys(false)) {
                ConfigurationSection itemSec = itemsSection.getConfigurationSection(key2);
                if (itemSec == null) continue;
                ShopSectionConfig.ShopItem item = new ShopSectionConfig.ShopItem();
                item.material = Material.matchMaterial((String)itemSec.getString("material", "STONE"));
                item.amount = itemSec.getInt("amount", 1);
                item.name = itemSec.getString("name", "");
                item.lore = itemSec.getStringList("lore");
                item.slot = itemSec.getInt("slot", -1);
                item.page = itemSec.getInt("page", 1);
                item.buyPrice = itemSec.getDouble("buy-price", -1.0);
                item.sellPrice = itemSec.getDouble("sell-price", -1.0);
                item.customItemId = itemSec.getString("custom-item-id", null);
                item.clickable = itemSec.getBoolean("clickable", true);
                section.items.put(key2, item);
            }
        }
        return section;
    }

    private static boolean isValidMainConfig(MainShopConfig config) {
        return config != null && config.size > 0 && config.layout != null && config.sectionButtons != null;
    }

    private static boolean isValidSectionConfig(ShopSectionConfig config) {
        return config != null && config.size > 0 && config.layout != null && config.items != null;
    }

    public static void saveMainConfig(File file, MainShopConfig main) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("title", (Object)main.title);
        config.set("size", (Object)main.size);
        config.set("layout", null);
        main.layout.forEach((slot, item) -> {
            config.set("layout." + slot + ".material", (Object)item.material.name());
            config.set("layout." + slot + ".name", (Object)item.name);
            config.set("layout." + slot + ".clickable", (Object)item.clickable);
        });
        config.set("sections", null);
        main.sectionButtons.forEach((slot, button) -> {
            config.set("sections." + slot + ".material", (Object)button.material.name());
            config.set("sections." + slot + ".name", (Object)button.name);
            config.set("sections." + slot + ".lore", button.lore);
            config.set("sections." + slot + ".file", (Object)button.file);
        });
        try {
            config.save(file);
        }
        catch (Exception e) {
            System.err.println("Failed to save main config: " + e.getMessage());
        }
    }

    public static void saveSectionConfig(File file, ShopSectionConfig section) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("title", (Object)section.title);
        config.set("size", (Object)section.size);
        config.set("pages", (Object)section.pages);
        config.set("player-head-slot", (Object)section.playerHeadSlot);
        config.set("close-button-slot", (Object)section.closeButtonSlot);
        config.set("layout", null);
        section.layout.forEach((slot, item) -> {
            config.set("layout." + slot + ".material", (Object)item.material.name());
            config.set("layout." + slot + ".name", (Object)item.name);
            config.set("layout." + slot + ".lore", item.lore);
            config.set("layout." + slot + ".clickable", (Object)item.clickable);
        });
        config.set("items", null);
        section.items.forEach((key, item) -> {
            config.set("items." + key + ".material", (Object)item.material.name());
            config.set("items." + key + ".amount", (Object)item.amount);
            config.set("items." + key + ".name", (Object)item.name);
            config.set("items." + key + ".lore", item.lore);
            config.set("items." + key + ".slot", (Object)item.slot);
            config.set("items." + key + ".page", (Object)item.page);
            config.set("items." + key + ".buy-price", (Object)item.buyPrice);
            config.set("items." + key + ".sell-price", (Object)item.sellPrice);
            config.set("items." + key + ".custom-item-id", (Object)item.customItemId);
            config.set("items." + key + ".clickable", (Object)item.clickable);
        });
        try {
            config.save(file);
        }
        catch (Exception e) {
            System.err.println("Failed to save section config: " + e.getMessage());
        }
    }
}

