/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.shop.api;

import com.serveressentials.api.shop.ShopAPI;
import com.serveressentials.api.shop.ShopItem;
import com.serveressentials.api.shop.ShopLayout;
import com.serveressentials.api.shop.ShopSection;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.godlycow.org.commands.config.ShopConfig;
import net.godlycow.org.economy.shop.ShopDataManager;
import net.godlycow.org.economy.shop.config.ShopSectionConfig;
import net.godlycow.org.economy.shop.gui.ShopGUIManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ShopAPIImpl
implements ShopAPI {
    private final ShopConfig config;
    private final ShopGUIManager guiManager;
    private final ShopDataManager dataManager;

    public ShopAPIImpl(ShopConfig config, ShopGUIManager guiManager, ShopDataManager dataManager) {
        this.config = config;
        this.guiManager = guiManager;
        this.dataManager = dataManager;
    }

    @Override
    public void openShop(Player player) {
        Bukkit.getScheduler().runTask(this.guiManager.getPlugin(), () -> this.guiManager.openMainGUI(player));
    }

    @Override
    public void openShopSection(Player player, String sectionName) {
        Bukkit.getScheduler().runTask(this.guiManager.getPlugin(), () -> this.guiManager.openSectionGUI(player, sectionName, 1));
    }

    @Override
    public CompletableFuture<Boolean> reloadShop() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Bukkit.getScheduler().callSyncMethod(this.guiManager.getPlugin(), () -> {
                    this.guiManager.reloadConfigs(true);
                    this.guiManager.refreshOpenInventories();
                    return null;
                }).get();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    @Override
    public boolean isShopEnabled() {
        return this.config.enabled;
    }

    @Override
    public Collection<String> getSectionNames() {
        return this.guiManager.getSectionCache().keySet();
    }

    @Override
    public ShopSection getSection(String sectionName) {
        ShopSectionConfig config = this.guiManager.getSectionConfig(sectionName);
        if (config == null) {
            return null;
        }
        return this.convertSection(config);
    }

    private ShopSection convertSection(ShopSectionConfig config) {
        Map<Integer, ShopLayout> layout = config.layout.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ShopLayout(((ShopSectionConfig.LayoutItem)e.getValue()).material, ((ShopSectionConfig.LayoutItem)e.getValue()).name, ((ShopSectionConfig.LayoutItem)e.getValue()).lore, ((ShopSectionConfig.LayoutItem)e.getValue()).clickable)));
        Map<String, ShopItem> items = config.items.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ShopItem(((ShopSectionConfig.ShopItem)e.getValue()).material, ((ShopSectionConfig.ShopItem)e.getValue()).amount, ((ShopSectionConfig.ShopItem)e.getValue()).name, ((ShopSectionConfig.ShopItem)e.getValue()).lore, ((ShopSectionConfig.ShopItem)e.getValue()).buyPrice, ((ShopSectionConfig.ShopItem)e.getValue()).sellPrice, ((ShopSectionConfig.ShopItem)e.getValue()).customItemId, ((ShopSectionConfig.ShopItem)e.getValue()).slot, ((ShopSectionConfig.ShopItem)e.getValue()).page, ((ShopSectionConfig.ShopItem)e.getValue()).clickable)));
        return new ShopSection(config.title, config.size, config.pages, config.playerHeadSlot, config.closeButtonSlot, layout, items);
    }
}

