/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.shop;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.database.DatabaseManager;
import net.godlycow.org.economy.shop.config.MainShopConfig;
import net.godlycow.org.economy.shop.config.ShopSectionConfig;
import org.bukkit.plugin.Plugin;

public class ShopDataManager {
    private final Plugin plugin;
    private final DatabaseManager dbManager;
    private static final String POOL_KEY = "shop";
    private static final String TABLE_SECTIONS = "shop_sections";
    private static final String TABLE_MAIN = "shop_main";

    public ShopDataManager(Plugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.initializeTables();
    }

    private void initializeTables() {
        ((CompletableFuture)this.dbManager.executeUpdate(POOL_KEY, "CREATE TABLE IF NOT EXISTS shop_sections (section_name TEXT PRIMARY KEY, title TEXT NOT NULL, size INTEGER NOT NULL, pages INTEGER NOT NULL DEFAULT 1, player_head_slot INTEGER NOT NULL DEFAULT -1, close_button_slot INTEGER NOT NULL DEFAULT -1, layout_json TEXT NOT NULL, items_json TEXT NOT NULL, updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)", new Object[0]).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to create shop_sections table: " + ex.getMessage());
            return null;
        })).join();
        ((CompletableFuture)this.dbManager.executeUpdate(POOL_KEY, "CREATE TABLE IF NOT EXISTS shop_main (config_key TEXT PRIMARY KEY, title TEXT NOT NULL, size INTEGER NOT NULL, layout_json TEXT NOT NULL, sections_json TEXT NOT NULL, updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)", new Object[0]).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to create shop_main table: " + ex.getMessage());
            return null;
        })).join();
    }

    public CompletableFuture<Long> getMainConfigLastUpdate() {
        return this.dbManager.executeQuery(POOL_KEY, "SELECT updated_at FROM shop_main WHERE config_key = ?", rs -> {
            if (rs.next()) {
                return rs.getTimestamp("updated_at").getTime();
            }
            return 0L;
        }, "main").thenApply(opt -> opt.orElse(0L));
    }

    public CompletableFuture<Long> getSectionLastUpdate(String sectionName) {
        return this.dbManager.executeQuery(POOL_KEY, "SELECT updated_at FROM shop_sections WHERE section_name = ?", rs -> {
            if (rs.next()) {
                return rs.getTimestamp("updated_at").getTime();
            }
            return 0L;
        }, sectionName).thenApply(opt -> opt.orElse(0L));
    }

    public CompletableFuture<Boolean> saveSectionConfig(String sectionName, ShopSectionConfig section) {
        String layoutJson = JsonHelper.toJson(section.layout);
        String itemsJson = JsonHelper.toJson(section.items);
        return ((CompletableFuture)this.dbManager.executeUpdate(POOL_KEY, "INSERT OR REPLACE INTO shop_sections (section_name, title, size, pages, player_head_slot, close_button_slot, layout_json, items_json) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", sectionName, section.title != null ? section.title : "", section.size, section.pages, section.playerHeadSlot, section.closeButtonSlot, layoutJson, itemsJson).thenApply(v -> true)).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to save section config: " + ex.getMessage());
            return false;
        });
    }

    public CompletableFuture<Boolean> saveMainConfig(MainShopConfig main) {
        String layoutJson = JsonHelper.toJson(main.layout);
        String sectionsJson = JsonHelper.toJson(main.sectionButtons);
        return ((CompletableFuture)this.dbManager.executeUpdate(POOL_KEY, "INSERT OR REPLACE INTO shop_main (config_key, title, size, layout_json, sections_json) VALUES (?, ?, ?, ?, ?)", "main", main.title != null ? main.title : "", main.size, layoutJson, sectionsJson).thenApply(v -> true)).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to save main config: " + ex.getMessage());
            return false;
        });
    }

    public CompletableFuture<ShopSectionConfig> loadSectionConfig(String sectionName) {
        return this.dbManager.executeQuery(POOL_KEY, "SELECT title, size, pages, player_head_slot, close_button_slot, layout_json, items_json FROM shop_sections WHERE section_name = ?", rs -> {
            if (!rs.next()) {
                return null;
            }
            ShopSectionConfig section = new ShopSectionConfig();
            section.title = rs.getString("title");
            section.size = rs.getInt("size");
            section.pages = rs.getInt("pages");
            section.playerHeadSlot = rs.getInt("player_head_slot");
            section.closeButtonSlot = rs.getInt("close_button_slot");
            Type layoutType = new TypeToken<Map<Integer, ShopSectionConfig.LayoutItem>>(this){}.getType();
            section.layout = (Map)JsonHelper.fromJson(rs.getString("layout_json"), layoutType);
            Type itemsType = new TypeToken<Map<String, ShopSectionConfig.ShopItem>>(this){}.getType();
            section.items = (Map)JsonHelper.fromJson(rs.getString("items_json"), itemsType);
            return section;
        }, sectionName).thenApply(opt -> opt.orElse(null));
    }

    public CompletableFuture<MainShopConfig> loadMainConfig() {
        return this.dbManager.executeQuery(POOL_KEY, "SELECT title, size, layout_json, sections_json FROM shop_main WHERE config_key = ?", rs -> {
            if (!rs.next()) {
                return null;
            }
            MainShopConfig main = new MainShopConfig();
            main.title = rs.getString("title");
            main.size = rs.getInt("size");
            Type layoutType = new TypeToken<Map<Integer, MainShopConfig.LayoutItem>>(this){}.getType();
            Type sectionsType = new TypeToken<Map<Integer, MainShopConfig.SectionButton>>(this){}.getType();
            main.layout = (Map)JsonHelper.fromJson(rs.getString("layout_json"), layoutType);
            main.sectionButtons = (Map)JsonHelper.fromJson(rs.getString("sections_json"), sectionsType);
            return main;
        }, "main").thenApply(opt -> opt.orElse(null));
    }

    public static class JsonHelper {
        private static final Gson gson = new Gson();

        public static String toJson(Object obj) {
            return gson.toJson(obj);
        }

        public static <T> T fromJson(String json, Class<T> clazz) {
            if (json == null || json.isEmpty()) {
                try {
                    return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return (T)gson.fromJson(json, clazz);
        }

        public static <T> T fromJson(String json, Type type) {
            if (json == null || json.isEmpty()) {
                return null;
            }
            return (T)gson.fromJson(json, type);
        }
    }
}

