/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.eco;

import java.util.concurrent.CompletableFuture;
import net.godlycow.org.database.DatabaseManager;
import net.godlycow.org.economy.eco.EconomyAPI;
import net.godlycow.org.economy.eco.EconomyResponse;
import net.godlycow.org.economy.eco.InternalEconomy;
import net.godlycow.org.economy.vault.VaultEconomyAdapter;
import net.godlycow.org.hooks.HooksManager;
import net.godlycow.org.hooks.VaultHook;
import net.godlycow.org.util.logger.AnsiColorUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EconomyManager {
    private static EconomyManager instance;
    private final Plugin plugin;
    private final DatabaseManager dbManager;
    private final HooksManager hooksManager;
    private EconomyAPI economy;
    private boolean enabled = false;
    private String economyName = "Disabled";

    private EconomyManager(Plugin plugin, DatabaseManager dbManager, HooksManager hooksManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.hooksManager = hooksManager;
    }

    public static EconomyManager getInstance(Plugin plugin, DatabaseManager dbManager, HooksManager hooksManager) {
        if (instance == null) {
            instance = new EconomyManager(plugin, dbManager, hooksManager);
        }
        return instance;
    }

    public void initialize() {
        VaultHook vault = this.hooksManager.getVault();
        if (vault != null && vault.hasEconomy()) {
            this.plugin.getLogger().info(AnsiColorUtil.success("Using Vault economy: " + vault.getEconomy().getName()));
            this.economy = new VaultEconomyAdapter(vault);
            this.economyName = vault.getEconomy().getName();
        } else {
            this.plugin.getLogger().info(AnsiColorUtil.warning("Using internal economy system"));
            this.economy = new InternalEconomy(this.plugin, this.dbManager);
            this.economyName = this.economy.getName();
            if (vault != null && this.hooksManager.isVaultActive()) {
                this.registerWithVault();
            }
        }
        this.enabled = true;
    }

    private void registerWithVault() {
        try {
            Class<?> bridgeClass = Class.forName("net.godlycow.org.economy.vault.VaultEconomyBridge");
            Object bridge = bridgeClass.getConstructor(Plugin.class, InternalEconomy.class, String.class).newInstance(this.plugin, (InternalEconomy)this.economy, this.economyName);
            bridgeClass.getMethod("register", new Class[0]).invoke(bridge, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning(AnsiColorUtil.danger("Could not register with Vault: " + e.getMessage()));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public EconomyAPI getEconomy() {
        return this.economy;
    }

    public String getEconomyName() {
        return this.economyName;
    }

    public double getBalance(Player player) {
        return this.economy.getBalance((OfflinePlayer)player);
    }

    public boolean has(Player player, double amount) {
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public EconomyResponse withdraw(Player player, double amount) {
        return this.economy.withdrawPlayer((OfflinePlayer)player, amount);
    }

    public EconomyResponse deposit(Player player, double amount) {
        return this.economy.depositPlayer((OfflinePlayer)player, amount);
    }

    public String format(double amount) {
        return this.economy.format(amount);
    }

    public CompletableFuture<Boolean> hasPaymentsDisabled(String playerUuid) {
        return this.economy.hasPaymentsDisabled(playerUuid);
    }

    public CompletableFuture<Void> setPaymentsDisabled(String playerUuid, String playerName, boolean disabled) {
        return this.economy.setPaymentsDisabled(playerUuid, playerName, disabled);
    }

    public CompletableFuture<Boolean> hasPayConfirmDisabled(String playerUuid) {
        return this.economy.hasPayConfirmDisabled(playerUuid);
    }

    public CompletableFuture<Void> setPayConfirmDisabled(String playerUuid, String playerName, boolean disabled) {
        return this.economy.setPayConfirmDisabled(playerUuid, playerName, disabled);
    }
}

