/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.economy.api;

import com.serveressentials.api.economy.EconomyAPI;
import com.serveressentials.api.economy.EconomyPaymentSettings;
import com.serveressentials.api.economy.EconomyResponse;
import com.serveressentials.api.economy.event.EconomyDepositEvent;
import com.serveressentials.api.economy.event.EconomyPaymentSettingsChangeEvent;
import com.serveressentials.api.economy.event.EconomyWithdrawEvent;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.EssC;
import net.godlycow.org.economy.eco.EconomyManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class EconomyAPIImpl
implements EconomyAPI {
    @NotNull
    private final EssC plugin;
    @NotNull
    private final EconomyManager economyManager;

    public EconomyAPIImpl(@NotNull EssC plugin, @NotNull EconomyManager economyManager) {
        this.plugin = plugin;
        this.economyManager = economyManager;
    }

    @Override
    public boolean isEnabled() {
        return this.economyManager.isEnabled();
    }

    @Override
    @NotNull
    public String getEconomyName() {
        return this.economyManager.getEconomyName();
    }

    @Override
    @NotNull
    public CompletableFuture<Double> getBalance(@NotNull OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> this.economyManager.getBalance(player.getPlayer()));
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> has(@NotNull OfflinePlayer player, double amount) {
        return CompletableFuture.supplyAsync(() -> this.economyManager.has(player.getPlayer(), amount));
    }

    @Override
    @NotNull
    public CompletableFuture<EconomyResponse> deposit(@NotNull OfflinePlayer player, double amount) {
        return CompletableFuture.supplyAsync(() -> {
            net.godlycow.org.economy.eco.EconomyResponse internal = this.economyManager.deposit(player.getPlayer(), amount);
            EconomyResponse response = new EconomyResponse(internal.amount, internal.balance, internal.success(), internal.errorMessage);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new EconomyDepositEvent(player, amount, response)));
            return response;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<EconomyResponse> withdraw(@NotNull OfflinePlayer player, double amount) {
        return CompletableFuture.supplyAsync(() -> {
            net.godlycow.org.economy.eco.EconomyResponse internal = this.economyManager.withdraw(player.getPlayer(), amount);
            EconomyResponse response = new EconomyResponse(internal.amount, internal.balance, internal.success(), internal.errorMessage);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new EconomyWithdrawEvent(player, amount, response)));
            return response;
        });
    }

    @Override
    @NotNull
    public String format(double amount) {
        return this.economyManager.format(amount);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> createAccount(@NotNull OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> this.economyManager.getEconomy().createPlayerAccount(player));
    }

    @Override
    @NotNull
    public CompletableFuture<EconomyPaymentSettings> getPaymentSettings(@NotNull String playerUuid) {
        return this.economyManager.hasPaymentsDisabled(playerUuid).thenCombine(this.economyManager.hasPayConfirmDisabled(playerUuid), (paymentsDisabled, confirmDisabled) -> new EconomyPaymentSettings((boolean)paymentsDisabled, (boolean)confirmDisabled));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> setPaymentsDisabled(@NotNull String playerUuid, @NotNull String playerName, boolean disabled) {
        return this.getPaymentSettings(playerUuid).thenCompose(oldSettings -> this.economyManager.setPaymentsDisabled(playerUuid, playerName, disabled).thenRun(() -> {
            EconomyPaymentSettings newSettings = new EconomyPaymentSettings(disabled, oldSettings.isPayConfirmDisabled());
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUuid));
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new EconomyPaymentSettingsChangeEvent(player, (EconomyPaymentSettings)oldSettings, newSettings)));
        }));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> setPayConfirmDisabled(@NotNull String playerUuid, @NotNull String playerName, boolean disabled) {
        return this.getPaymentSettings(playerUuid).thenCompose(oldSettings -> this.economyManager.setPayConfirmDisabled(playerUuid, playerName, disabled).thenRun(() -> {
            EconomyPaymentSettings newSettings = new EconomyPaymentSettings(oldSettings.isPaymentsDisabled(), disabled);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUuid));
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new EconomyPaymentSettingsChangeEvent(player, (EconomyPaymentSettings)oldSettings, newSettings)));
        }));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> this.plugin.getLogger().info("[ServerEssentials] Economy configuration reloaded"));
    }
}

