/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.godlycow.org.database.DatabaseConfig;
import net.godlycow.org.database.type.DatabaseType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class DatabaseManager {
    private final Plugin plugin;
    private final Map<String, HikariDataSource> pools = new ConcurrentHashMap<String, HikariDataSource>();
    private final Map<String, DatabaseStatus> statusMap = new ConcurrentHashMap<String, DatabaseStatus>();

    public DatabaseManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void initializePool(String key, DatabaseConfig config) {
        block12: {
            try {
                this.plugin.getLogger().info("Initializing database pool: " + key + " (" + String.valueOf((Object)config.type()) + ")");
                HikariConfig hc = new HikariConfig();
                if (config.type() == DatabaseType.SQLITE) {
                    File dbFile = new File(this.getDatabaseFolder(), config.sqliteFile());
                    String path = dbFile.getAbsolutePath();
                    hc.setJdbcUrl("jdbc:sqlite:" + path);
                    hc.setDriverClassName("org.sqlite.JDBC");
                    hc.addDataSourceProperty("journal_mode", "WAL");
                    hc.addDataSourceProperty("synchronous", "NORMAL");
                } else {
                    String jdbc = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&serverTimezone=UTC&allowPublicKeyRetrieval=true&connectTimeout=5000&socketTimeout=30000", config.mysqlHost(), config.mysqlPort(), config.mysqlDatabase());
                    hc.setJdbcUrl(jdbc);
                    hc.setUsername(config.mysqlUser());
                    hc.setPassword(config.mysqlPassword());
                    hc.setDriverClassName("com.mysql.cj.jdbc.Driver");
                    hc.setMaximumPoolSize(config.poolSize());
                    hc.setMinimumIdle(Math.min(1, config.poolSize() - 1));
                    hc.setConnectionTimeout(5000L);
                    hc.setIdleTimeout(600000L);
                    hc.setMaxLifetime(1800000L);
                    hc.setLeakDetectionThreshold(60000L);
                    this.plugin.getLogger().info("MySQL connection: " + config.mysqlHost() + ":" + config.mysqlPort());
                }
                HikariDataSource ds = new HikariDataSource(hc);
                try (Connection conn = ds.getConnection();){
                    if (conn.isValid(3)) {
                        this.pools.put(key, ds);
                        this.statusMap.put(key, new DatabaseStatus(true, "Connected successfully", Instant.now()));
                        break block12;
                    }
                    ds.close();
                    throw new SQLException("Connection validation failed");
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database pool: " + key, ex);
                this.statusMap.put(key, new DatabaseStatus(false, ex.getMessage(), Instant.now()));
                if (config.type() == DatabaseType.MYSQL) {
                    this.diagnoseMySQL(config);
                }
                this.plugin.getLogger().warning("Plugin will continue without this database. Features will be limited.");
            }
        }
    }

    private void diagnoseMySQL(DatabaseConfig config) {
        this.plugin.getLogger().warning("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.plugin.getLogger().warning("\u2551        MySQL Connection Failed - Diagnostics          \u2551");
        this.plugin.getLogger().warning("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        this.plugin.getLogger().warning("  Host: " + config.mysqlHost() + ":" + config.mysqlPort());
        this.plugin.getLogger().warning("  Database: " + config.mysqlDatabase());
        this.plugin.getLogger().warning("  User: " + config.mysqlUser());
        this.plugin.getLogger().warning("\u2551 SOLUTIONS:");
        this.plugin.getLogger().warning("\u2551 1. Verify MySQL is running: sudo systemctl status mysql");
        this.plugin.getLogger().warning("\u2551 2. Test manually: mysql -u " + config.mysqlUser() + " -p -h " + config.mysqlHost());
        this.plugin.getLogger().warning("\u2551 3. Check firewall: sudo ufw allow 3306");
        this.plugin.getLogger().warning("\u2551 4. Check bind-address in my.cnf (should be 0.0.0.0)");
        this.plugin.getLogger().warning("\u2551 5. Grant remote access: GRANT ALL ON " + config.mysqlDatabase() + ".* TO '" + config.mysqlUser() + "'@'%';");
        this.plugin.getLogger().warning("\u2551 6. Try SQLite instead if you don't need remote DB!");
    }

    public CompletableFuture<Void> executeUpdate(String poolKey, String sql, Object ... params) {
        return CompletableFuture.runAsync(() -> {
            HikariDataSource ds = this.pools.get(poolKey);
            if (ds == null) {
                throw new IllegalStateException("No such database pool: " + poolKey);
            }
            try (Connection conn = ds.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
                ps.executeUpdate();
                this.statusMap.put(poolKey, new DatabaseStatus(true, "OK", Instant.now()));
            }
            catch (SQLException e) {
                this.statusMap.put(poolKey, new DatabaseStatus(false, e.getMessage(), Instant.now()));
                this.plugin.getLogger().log(Level.SEVERE, "SQL Error in pool '" + poolKey + "': " + sql, e);
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<Optional<T>> executeQuery(String poolKey, String sql, ResultMapper<T> mapper, Object ... params) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public Map<String, DatabaseStatus> getAllStatus() {
        return new HashMap<String, DatabaseStatus>(this.statusMap);
    }

    public boolean isPoolConnected(String key) {
        DatabaseStatus status = this.statusMap.get(key);
        if (status == null) {
            return false;
        }
        if (status.connected()) {
            return this.testConnection(key);
        }
        return false;
    }

    private boolean testConnection(String key) {
        boolean bl;
        block9: {
            HikariDataSource ds = this.pools.get(key);
            if (ds == null) {
                return false;
            }
            Connection conn = ds.getConnection();
            try {
                bl = conn.isValid(2);
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    public void closePool(String key) {
        HikariDataSource ds = this.pools.remove(key);
        if (ds != null) {
            ds.close();
            this.plugin.getLogger().info("Closed database pool: " + key);
        }
    }

    public void closeAll() {
        new HashMap<String, HikariDataSource>(this.pools).forEach((key, ds) -> {
            try {
                ds.close();
                this.plugin.getLogger().info("Closed database pool: " + key);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error closing pool: " + key, e);
            }
        });
        this.pools.clear();
        this.statusMap.clear();
    }

    private File getDatabaseFolder() {
        File folder = new File(this.plugin.getDataFolder(), "databases");
        if (!folder.exists() && !folder.mkdirs()) {
            this.plugin.getLogger().warning("Failed to create databases folder!");
        }
        return folder;
    }

    public Set<String> getPoolKeys() {
        return Collections.unmodifiableSet(this.pools.keySet());
    }

    public record DatabaseStatus(boolean connected, String message, Instant lastCheck) {
    }

    @FunctionalInterface
    public static interface ResultMapper<T> {
        @Nullable
        public T map(ResultSet var1) throws Exception;
    }
}

