/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.daily.trigger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.daily.DailyConfig;
import net.godlycow.org.daily.reward.DailyReward;
import net.godlycow.org.daily.storage.DailyStorage;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DailyListener
implements Listener {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final DailyStorage storage;
    private final DailyConfig config;
    private final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private static final String GUI_NAMESPACE = "daily_gui";
    private static final String REWARD_ID_KEY = "daily_reward_day";
    private static final String ITEM_TYPE_KEY = "daily_item_type";
    private static final String GUI_IDENTIFIER_KEY = "daily_gui_identifier";
    private static final String GUI_IDENTIFIER_VALUE = "daily_rewards_gui";

    public DailyListener(JavaPlugin plugin, PlayerLanguageManager langManager, DailyStorage storage, DailyConfig config) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
    }

    public void openRewardsGUI(final Player player, final int page) {
        this.playerPages.put(player.getUniqueId(), page);
        Component title = this.langManager.getMessageFor(player, "commands.daily.gui.title", "<green><bold>Daily Rewards</bold> - Page {page}", LanguageManager.ComponentPlaceholder.of("{page}", page));
        final Inventory gui = Bukkit.createInventory(null, (int)(this.config.guiRows * 9), (Component)title);
        CompletableFuture.allOf(this.storage.getClaimedDays(player.getUniqueId()), this.storage.hasClaimedToday(player.getUniqueId(), this.config.cooldownHours)).thenAccept(results -> {
            final HashSet claimedDays = new HashSet();
            boolean[] onCooldown = new boolean[]{false};
            this.storage.getClaimedDays(player.getUniqueId()).thenAccept(days -> {
                claimedDays.addAll(days);
                this.storage.getTimeUntilNextClaim(player.getUniqueId(), this.config.cooldownHours).thenAccept(duration -> {
                    onCooldown[0] = duration.onCooldown();
                    new BukkitRunnable((DailyStorage.DurationInfo)duration){
                        final /* synthetic */ DailyStorage.DurationInfo val$duration;
                        {
                            this.val$duration = durationInfo;
                        }

                        public void run() {
                            DailyListener.this.buildGUIContents(gui, player, page, claimedDays, this.val$duration);
                            player.openInventory(gui);
                            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
                        }
                    }.runTask((Plugin)this.plugin);
                });
            });
        });
    }

    private void buildGUIContents(Inventory gui, Player player, int page, Set<Integer> claimedDays, DailyStorage.DurationInfo duration) {
        gui.clear();
        this.config.rewards.values().stream().filter(reward -> reward.page == page).forEach(reward -> {
            ItemStack item = this.createRewardDisplayItem((DailyReward)reward, claimedDays, player, duration);
            gui.setItem(reward.slot, item);
        });
        if (page > 1) {
            gui.setItem(45, this.createNavItem(Material.ARROW, "commands.daily.gui.previous", "<yellow>Previous Page", player, "NAV_PREVIOUS"));
        }
        if (this.hasNextPage(page)) {
            gui.setItem(53, this.createNavItem(Material.ARROW, "commands.daily.gui.next", "<yellow>Next Page", player, "NAV_NEXT"));
        }
        gui.setItem(this.config.guiRows * 9 - 5, this.createNavItem(Material.BARRIER, "commands.daily.gui.close", "<red>Close", player, "CLOSE"));
    }

    private ItemStack createRewardDisplayItem(DailyReward reward, Set<Integer> claimedDays, Player player, DailyStorage.DurationInfo duration) {
        ItemMeta meta;
        ItemStack item;
        boolean isOnCooldown;
        UUID uuid = player.getUniqueId();
        boolean isClaimed = claimedDays.contains(reward.day);
        boolean isUnlocked = this.canClaimDay(claimedDays, reward.day);
        boolean bl = isOnCooldown = duration.onCooldown() && !isClaimed;
        if (isClaimed) {
            item = this.createActualRewardItem(reward.items.get(0), player);
            meta = item.getItemMeta();
            name = this.langManager.getMessageFor(player, "commands.daily.rewards.claimed.name", "<green><bold>\u2713 Claimed</bold>", new LanguageManager.ComponentPlaceholder[0]);
            meta.displayName(name);
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(Component.empty());
            lore.add(this.langManager.getMessageFor(player, "commands.daily.rewards.claimed.lore", "<gray>You have claimed this reward.", new LanguageManager.ComponentPlaceholder[0]));
            meta.lore(lore);
            if (reward.items.get((int)0).glow) {
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        } else if (isOnCooldown) {
            item = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            meta = item.getItemMeta();
            name = this.langManager.getMessageFor(player, "commands.daily.rewards.cooldown.name", "<gold><bold>\u23f1 Cooldown</bold>", new LanguageManager.ComponentPlaceholder[0]);
            meta.displayName(name);
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(Component.empty());
            lore.add(this.langManager.getMessageFor(player, "commands.daily.rewards.cooldown.lore", "<gray>Wait: <gold>{time}", LanguageManager.ComponentPlaceholder.of("{time}", duration.format())));
            meta.lore(lore);
        } else if (!isUnlocked) {
            item = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            meta = item.getItemMeta();
            name = this.langManager.getMessageFor(player, "commands.daily.rewards.locked.name", "<red><bold>\ud83d\udd12 Locked</bold>", new LanguageManager.ComponentPlaceholder[0]);
            meta.displayName(name);
            meta.lore(List.of(this.langManager.getMessageFor(player, "commands.daily.rewards.locked.lore", "<gray>Complete previous days first.", new LanguageManager.ComponentPlaceholder[0])));
        } else {
            item = this.createActualRewardItem(reward.items.get(0), player);
            meta = item.getItemMeta();
            name = this.langManager.getMessageFor(player, "commands.daily.rewards.available.name", "<green>Day {day}", LanguageManager.ComponentPlaceholder.of("{day}", reward.day));
            meta.displayName(name);
            ArrayList<Component> lore = new ArrayList<Component>();
            lore.add(Component.empty());
            reward.items.get((int)0).lore.forEach(line -> lore.add(this.langManager.getMessageFor(player, (String)line, (String)line, new LanguageManager.ComponentPlaceholder[0])));
            lore.add(Component.empty());
            lore.add(this.langManager.getMessageFor(player, "commands.daily.gui.cooldown-display", "<gray>Cooldown: <yellow>{time}", LanguageManager.ComponentPlaceholder.of("{time}", this.config.cooldownHours + "h")));
            meta.lore(lore);
            if (reward.items.get((int)0).glow) {
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)this.plugin, REWARD_ID_KEY), PersistentDataType.INTEGER, (Object)reward.day);
        container.set(new NamespacedKey((Plugin)this.plugin, ITEM_TYPE_KEY), PersistentDataType.STRING, (Object)"REWARD");
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createActualRewardItem(DailyReward.RewardItem rewardItem, Player player) {
        ItemStack item = new ItemStack(rewardItem.material, rewardItem.amount);
        ItemMeta meta = item.getItemMeta();
        if (!rewardItem.name.isEmpty()) {
            meta.displayName(this.langManager.getMessageFor(player, rewardItem.name, rewardItem.name, new LanguageManager.ComponentPlaceholder[0]));
        }
        if (!rewardItem.lore.isEmpty()) {
            ArrayList lore = new ArrayList();
            rewardItem.lore.forEach(line -> lore.add(this.langManager.getMessageFor(player, (String)line, (String)line, new LanguageManager.ComponentPlaceholder[0])));
            meta.lore(lore);
        }
        rewardItem.enchantments.forEach((enchantName, level) -> {
            Enchantment enchant = Enchantment.getByName((String)enchantName.toUpperCase());
            if (enchant != null) {
                meta.addEnchant(enchant, level.intValue(), true);
            }
        });
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createNavItem(Material material, String messageKey, String def, Player player, String itemType) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(player, messageKey, def, new LanguageManager.ComponentPlaceholder[0]));
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)this.plugin, ITEM_TYPE_KEY), PersistentDataType.STRING, (Object)itemType);
        if ("CLOSE".equals(itemType)) {
            container.set(new NamespacedKey((Plugin)this.plugin, GUI_IDENTIFIER_KEY), PersistentDataType.STRING, (Object)GUI_IDENTIFIER_VALUE);
        }
        item.setItemMeta(meta);
        return item;
    }

    private boolean canClaimDay(Set<Integer> claimedDays, int day) {
        for (int i = 1; i < day; ++i) {
            if (claimedDays.contains(i)) continue;
            return false;
        }
        return true;
    }

    private boolean hasNextPage(int currentPage) {
        return this.config.rewards.values().stream().anyMatch(r -> r.page > currentPage);
    }

    private boolean isDailyRewardsGUI(Inventory inventory) {
        if (inventory == null) {
            return false;
        }
        int closeButtonSlot = this.config.guiRows * 9 - 5;
        if (closeButtonSlot >= inventory.getSize()) {
            return false;
        }
        ItemStack closeButton = inventory.getItem(closeButtonSlot);
        if (closeButton == null || closeButton.getType() != Material.BARRIER) {
            return false;
        }
        ItemMeta meta = closeButton.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String identifier = (String)container.get(new NamespacedKey((Plugin)this.plugin, GUI_IDENTIFIER_KEY), PersistentDataType.STRING);
        return GUI_IDENTIFIER_VALUE.equals(identifier);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.isDailyRewardsGUI(e.getInventory())) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType().isAir()) {
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String itemType = (String)container.get(new NamespacedKey((Plugin)this.plugin, ITEM_TYPE_KEY), PersistentDataType.STRING);
        if (itemType == null) {
            return;
        }
        switch (itemType) {
            case "REWARD": {
                Integer rewardDay = (Integer)container.get(new NamespacedKey((Plugin)this.plugin, REWARD_ID_KEY), PersistentDataType.INTEGER);
                if (rewardDay == null) break;
                this.handleRewardClaim(player, rewardDay, e.getSlot());
                break;
            }
            case "NAV_PREVIOUS": {
                this.handleNavigation(player, -1);
                break;
            }
            case "NAV_NEXT": {
                this.handleNavigation(player, 1);
                break;
            }
            case "CLOSE": {
                player.closeInventory();
            }
        }
    }

    private void handleNavigation(final Player player, int direction) {
        int currentPage = this.playerPages.getOrDefault(player.getUniqueId(), 1);
        final int newPage = currentPage + direction;
        if (newPage < 1) {
            return;
        }
        if (direction > 0 && !this.hasNextPage(currentPage)) {
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        new BukkitRunnable(){

            public void run() {
                DailyListener.this.openRewardsGUI(player, newPage);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private void handleRewardClaim(final Player player, int day, int slot) {
        UUID uuid = player.getUniqueId();
        CompletableFuture.allOf(this.storage.getClaimedDays(uuid), this.storage.hasClaimedToday(uuid, this.config.cooldownHours)).thenCompose(results -> {
            HashSet claimedDays = new HashSet();
            return this.storage.getClaimedDays(uuid).thenCompose(days -> {
                claimedDays.addAll(days);
                boolean isClaimed = claimedDays.contains(day);
                boolean canClaim = this.canClaimDay(claimedDays, day);
                if (isClaimed) {
                    return CompletableFuture.runAsync(() -> new BukkitRunnable(){

                        public void run() {
                            player.sendMessage(DailyListener.this.langManager.getMessageFor(player, "commands.daily.messages.claim-already", "<red>You already claimed this reward!", new LanguageManager.ComponentPlaceholder[0]));
                            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        }
                    }.runTask((Plugin)this.plugin));
                }
                if (!canClaim) {
                    return CompletableFuture.runAsync(() -> new BukkitRunnable(){

                        public void run() {
                            player.sendMessage(DailyListener.this.langManager.getMessageFor(player, "commands.daily.messages.claim-locked", "<red>You must claim previous days first!", new LanguageManager.ComponentPlaceholder[0]));
                            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                        }
                    }.runTask((Plugin)this.plugin));
                }
                return this.storage.hasClaimedToday(uuid, this.config.cooldownHours).thenCompose(onCooldown -> {
                    if (onCooldown.booleanValue()) {
                        return this.storage.getTimeUntilNextClaim(uuid, this.config.cooldownHours).thenAccept(duration -> new BukkitRunnable((DailyStorage.DurationInfo)duration){
                            final /* synthetic */ DailyStorage.DurationInfo val$duration;
                            {
                                this.val$duration = durationInfo;
                            }

                            public void run() {
                                player.sendMessage(DailyListener.this.langManager.getMessageFor(player, "commands.daily.messages.claim-cooldown", "<red>You must wait {time} before claiming again!", LanguageManager.ComponentPlaceholder.of("{time}", this.val$duration.format())));
                                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                            }
                        }.runTask((Plugin)this.plugin));
                    }
                    return this.claimReward(player, day, uuid);
                });
            });
        });
    }

    private CompletableFuture<Void> claimReward(final Player player, final int day, final UUID uuid) {
        final DailyReward reward = this.config.rewards.get(day);
        if (reward == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.storage.claimReward(uuid, day).thenAccept(v -> new BukkitRunnable(){

            public void run() {
                for (DailyReward.RewardItem itemData : reward.items) {
                    ItemStack item = DailyListener.this.createActualRewardItem(itemData, player);
                    player.getInventory().addItem(new ItemStack[]{item});
                }
                player.sendMessage(DailyListener.this.langManager.getMessageFor(player, "commands.daily.messages.claim-success", "<green>You claimed Day {day} reward!", LanguageManager.ComponentPlaceholder.of("{day}", day)));
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                new BukkitRunnable(){

                    public void run() {
                        DailyListener.this.openRewardsGUI(player, DailyListener.this.playerPages.getOrDefault(uuid, 1));
                    }
                }.runTaskLater((Plugin)DailyListener.this.plugin, 1L);
            }
        }.runTask((Plugin)this.plugin))).exceptionally(ex -> {
            new BukkitRunnable(){

                public void run() {
                    player.sendMessage(DailyListener.this.langManager.getMessageFor(player, "commands.daily.messages.claim-error", "<red>Failed to claim reward. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
                }
            }.runTask((Plugin)this.plugin);
            return null;
        });
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        HumanEntity humanEntity = e.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (this.isDailyRewardsGUI(e.getInventory())) {
            this.playerPages.remove(player.getUniqueId());
        }
    }
}

