/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.daily.storage;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.database.DatabaseManager;
import org.bukkit.plugin.Plugin;

public class DailyStorage {
    private final DatabaseManager dbManager;
    private final String poolKey = "daily";
    private final Plugin plugin;

    public DailyStorage(Plugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.initTable();
    }

    private void initTable() {
        String sql = "CREATE TABLE IF NOT EXISTS daily_claims (player_uuid TEXT NOT NULL, day INTEGER NOT NULL, claimed_at BIGINT NOT NULL, PRIMARY KEY (player_uuid, day))";
        this.dbManager.executeUpdate("daily", sql, new Object[0]).join();
    }

    public CompletableFuture<Set<Integer>> getClaimedDays(UUID playerId) {
        String sql = "SELECT day FROM daily_claims WHERE player_uuid = ?";
        return this.dbManager.executeQuery("daily", sql, rs -> {
            HashSet<Integer> days = new HashSet<Integer>();
            while (rs.next()) {
                days.add(rs.getInt("day"));
            }
            return days;
        }, playerId.toString()).thenApply(opt -> opt.orElse(Set.of()));
    }

    public CompletableFuture<Optional<LocalDateTime>> getLastClaimTime(UUID playerId) {
        String sql = "SELECT MAX(claimed_at) as last_claim FROM daily_claims WHERE player_uuid = ?";
        return this.dbManager.executeQuery("daily", sql, rs -> {
            if (rs.next() && rs.getLong("last_claim") > 0L) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(rs.getLong("last_claim")), ZoneId.systemDefault());
            }
            return null;
        }, playerId.toString());
    }

    public CompletableFuture<Boolean> hasClaimedToday(UUID playerId, int cooldownHours) {
        return this.getLastClaimTime(playerId).thenApply(opt -> {
            if (opt.isEmpty()) {
                return false;
            }
            LocalDateTime lastClaim = (LocalDateTime)opt.get();
            LocalDateTime now = LocalDateTime.now();
            return !lastClaim.plusHours(cooldownHours).isBefore(now);
        });
    }

    public CompletableFuture<Void> claimReward(UUID playerId, int day) {
        String sql = "INSERT OR REPLACE INTO daily_claims VALUES (?, ?, ?)";
        return this.dbManager.executeUpdate("daily", sql, playerId.toString(), day, System.currentTimeMillis());
    }

    public CompletableFuture<DurationInfo> getTimeUntilNextClaim(UUID playerId, int cooldownHours) {
        return this.getLastClaimTime(playerId).thenApply(opt -> {
            LocalDateTime now = LocalDateTime.now();
            if (opt.isEmpty()) {
                return new DurationInfo(0L, 0L, 0L, false);
            }
            LocalDateTime nextAllowed = ((LocalDateTime)opt.get()).plusHours(cooldownHours);
            Duration remaining = Duration.between(now, nextAllowed);
            boolean isOnCooldown = !remaining.isNegative();
            return new DurationInfo(isOnCooldown ? (long)remaining.toHoursPart() : 0L, isOnCooldown ? (long)remaining.toMinutesPart() : 0L, isOnCooldown ? (long)remaining.toSecondsPart() : 0L, isOnCooldown);
        });
    }

    public record DurationInfo(long hours, long minutes, long seconds, boolean onCooldown) {
        public String format() {
            return String.format("%02dh %02dm %02ds", this.hours, this.minutes, this.seconds);
        }
    }
}

