/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.daily.api;

import com.serveressentials.api.daily.DailyAPI;
import com.serveressentials.api.daily.DailyCooldownInfo;
import com.serveressentials.api.daily.DailyRewardItem;
import com.serveressentials.api.daily.event.DailyGUIOpenEvent;
import com.serveressentials.api.daily.event.DailyRewardClaimEvent;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.EssC;
import net.godlycow.org.daily.DailyConfig;
import net.godlycow.org.daily.reward.DailyReward;
import net.godlycow.org.daily.storage.DailyStorage;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public final class DailyAPIImpl
implements DailyAPI {
    private static final String PERMISSION = "essc.command.daily";
    @NotNull
    private final EssC plugin;
    @NotNull
    private final DailyConfig config;
    @NotNull
    private final DailyStorage storage;
    @NotNull
    private final PlayerLanguageManager langManager;
    @NotNull
    private final Map<UUID, Integer> playerPages = new HashMap<UUID, Integer>();
    private static final String GUI_IDENTIFIER_KEY = "daily_gui_identifier";
    private static final String GUI_IDENTIFIER_VALUE = "daily_rewards_gui";
    private static final String ITEM_TYPE_KEY = "daily_item_type";

    public DailyAPIImpl(@NotNull EssC plugin, @NotNull DailyConfig config, @NotNull DailyStorage storage, @NotNull PlayerLanguageManager langManager) {
        this.plugin = plugin;
        this.config = config;
        this.storage = storage;
        this.langManager = langManager;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> openDailyGUI(final @NotNull Player player, final int page) {
        if (!player.hasPermission(PERMISSION)) {
            this.sendMessage(player, "commands.daily.command.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            return CompletableFuture.completedFuture(false);
        }
        this.playerPages.put(player.getUniqueId(), page);
        Component title = this.langManager.getMessageFor(player, "commands.daily.gui.title", "<green><bold>Daily Rewards</bold> - Page {page}", LanguageManager.ComponentPlaceholder.of("{page}", String.valueOf(page)));
        final Inventory gui = Bukkit.createInventory(null, (int)(this.config.guiRows * 9), (Component)title);
        return ((CompletableFuture)CompletableFuture.allOf(this.storage.getClaimedDays(player.getUniqueId()), this.storage.hasClaimedToday(player.getUniqueId(), this.config.cooldownHours)).thenCompose(results -> this.storage.getClaimedDays(player.getUniqueId()).thenCompose(claimedDays -> this.storage.getTimeUntilNextClaim(player.getUniqueId(), this.config.cooldownHours).thenApply(duration -> {
            new BukkitRunnable((Set)claimedDays, (DailyStorage.DurationInfo)duration){
                final /* synthetic */ Set val$claimedDays;
                final /* synthetic */ DailyStorage.DurationInfo val$duration;
                {
                    this.val$claimedDays = set;
                    this.val$duration = durationInfo;
                }

                public void run() {
                    DailyAPIImpl.this.buildGUIContents(gui, player, page, this.val$claimedDays, this.val$duration);
                    player.openInventory(gui);
                    player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
                    Bukkit.getPluginManager().callEvent((Event)new DailyGUIOpenEvent(player, page));
                }
            }.runTask((Plugin)this.plugin);
            return true;
        })))).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to open daily GUI: " + ex.getMessage());
            return false;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> claimReward(final @NotNull Player player, final int day) {
        if (!player.hasPermission(PERMISSION)) {
            return CompletableFuture.completedFuture(false);
        }
        UUID uuid = player.getUniqueId();
        return this.storage.getClaimedDays(uuid).thenCompose(claimedDays -> {
            boolean isClaimed = claimedDays.contains(day);
            boolean canClaim = this.canClaimDay((Set<Integer>)claimedDays, day);
            if (isClaimed) {
                this.sendMessage(player, "commands.daily.messages.claim-already", "<red>You already claimed this reward!", new LanguageManager.ComponentPlaceholder[0]);
                return CompletableFuture.completedFuture(false);
            }
            if (!canClaim) {
                this.sendMessage(player, "commands.daily.messages.claim-locked", "<red>You must claim previous days first!", new LanguageManager.ComponentPlaceholder[0]);
                return CompletableFuture.completedFuture(false);
            }
            return this.storage.hasClaimedToday(uuid, this.config.cooldownHours).thenCompose(onCooldown -> {
                if (onCooldown.booleanValue()) {
                    return this.storage.getTimeUntilNextClaim(uuid, this.config.cooldownHours).thenApply(duration -> {
                        this.sendMessage(player, "commands.daily.messages.claim-cooldown", "<red>You must wait {time} before claiming again!", LanguageManager.ComponentPlaceholder.of("{time}", duration.format()));
                        return false;
                    });
                }
                final DailyReward.RewardItem rewardItem = this.getRewardItem(day);
                if (rewardItem == null) {
                    return CompletableFuture.completedFuture(false);
                }
                return ((CompletableFuture)this.storage.claimReward(uuid, day).thenApply(v -> {
                    new BukkitRunnable(){

                        public void run() {
                            ItemStack item = DailyAPIImpl.this.createRewardItem(rewardItem, player);
                            player.getInventory().addItem(new ItemStack[]{item});
                            DailyAPIImpl.this.sendMessage(player, "commands.daily.messages.claim-success", "<green>You claimed Day {day} reward!", LanguageManager.ComponentPlaceholder.of("{day}", String.valueOf(day)));
                            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
                            DailyRewardItem dtoItem = new DailyRewardItem(rewardItem.material, rewardItem.amount, rewardItem.name, rewardItem.lore, rewardItem.enchantments, rewardItem.glow, rewardItem.nbt);
                            com.serveressentials.api.daily.DailyReward dtoReward = new com.serveressentials.api.daily.DailyReward(day, 0, 0, List.of(dtoItem));
                            Bukkit.getScheduler().runTaskAsynchronously((Plugin)DailyAPIImpl.this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new DailyRewardClaimEvent(player, day, dtoReward)));
                        }
                    }.runTask((Plugin)this.plugin);
                    return true;
                })).exceptionally(ex -> {
                    this.sendMessage(player, "commands.daily.messages.claim-error", "<red>Failed to claim reward.", new LanguageManager.ComponentPlaceholder[0]);
                    return false;
                });
            });
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<LocalDateTime>> getLastClaimTime(@NotNull UUID playerId) {
        return this.storage.getLastClaimTime(playerId);
    }

    @Override
    @NotNull
    public CompletableFuture<Set<Integer>> getClaimedDays(@NotNull UUID playerId) {
        return this.storage.getClaimedDays(playerId);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> hasClaimedToday(@NotNull UUID playerId) {
        return this.storage.hasClaimedToday(playerId, this.config.cooldownHours);
    }

    @Override
    @NotNull
    public CompletableFuture<DailyCooldownInfo> getTimeUntilNextClaim(@NotNull UUID playerId) {
        return this.storage.getTimeUntilNextClaim(playerId, this.config.cooldownHours).thenApply(dto -> new DailyCooldownInfo(dto.hours(), dto.minutes(), dto.seconds(), dto.onCooldown()));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> reload() {
        return CompletableFuture.runAsync(() -> {
            this.config.reload();
            this.plugin.getLogger().info("[ServerEssentials] Daily rewards configuration reloaded");
        });
    }

    @Override
    public boolean isDailyEnabled() {
        return this.plugin.getConfig().getBoolean("daily.enabled", true);
    }

    private void buildGUIContents(Inventory gui, Player player, int page, Set<Integer> claimedDays, DailyStorage.DurationInfo duration) {
        gui.clear();
        this.config.rewards.values().stream().filter(reward -> reward.page == page).forEach(reward -> {
            ItemStack item = this.createRewardDisplayItem(reward.items.get(0), reward.day, claimedDays, player, duration);
            gui.setItem(reward.slot, item);
        });
        if (page > 1) {
            gui.setItem(45, this.createNavItem(Material.ARROW, "commands.daily.gui.previous", "<yellow>Previous Page", player, "NAV_PREVIOUS"));
        }
        if (this.hasNextPage(page)) {
            gui.setItem(53, this.createNavItem(Material.ARROW, "commands.daily.gui.next", "<yellow>Next Page", player, "NAV_NEXT"));
        }
        gui.setItem(this.config.guiRows * 9 - 5, this.createNavItem(Material.BARRIER, "commands.daily.gui.close", "<red>Close", player, "CLOSE"));
    }

    private ItemStack createRewardDisplayItem(DailyReward.RewardItem reward, int day, Set<Integer> claimedDays, Player player, DailyStorage.DurationInfo duration) {
        ItemStack item;
        boolean isOnCooldown;
        boolean isClaimed = claimedDays.contains(day);
        boolean canClaim = this.canClaimDay(claimedDays, day);
        boolean bl = isOnCooldown = duration.onCooldown() && !isClaimed;
        if (isClaimed) {
            item = this.createRewardItem(reward, player);
            this.applyMeta(item, player, "commands.daily.rewards.claimed.name", "<green><bold>\u2713 Claimed</bold>", LanguageManager.ComponentPlaceholder.of("lore", "daily.rewards.locked.lore|<gray>Complete previous days first."));
        } else if (isOnCooldown) {
            item = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            this.applyMeta(item, player, "commands.daily.rewards.cooldown.name", "<gold><bold>\u23f1 Cooldown</bold>", LanguageManager.ComponentPlaceholder.of("{time}", duration.format()));
        } else if (!canClaim) {
            item = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            this.applyMeta(item, player, "commands.daily.rewards.locked.name", "<red><bold>\ud83d\udd12 Locked</bold>", LanguageManager.ComponentPlaceholder.of("lore", "commands.daily.rewards.locked.lore|<gray>Complete previous days first."));
        } else {
            item = this.createRewardItem(reward, player);
            this.applyMeta(item, player, "commands.daily.rewards.available.name", "<green>Day {day}", LanguageManager.ComponentPlaceholder.of("{day}", String.valueOf(day)), LanguageManager.ComponentPlaceholder.of("{time}", this.config.cooldownHours + "h"));
        }
        return item;
    }

    private ItemStack createRewardItem(DailyReward.RewardItem itemData, Player player) {
        ItemStack item = new ItemStack(itemData.material, itemData.amount);
        ItemMeta meta = item.getItemMeta();
        if (!itemData.name.isEmpty()) {
            meta.displayName(this.langManager.getMessageFor(player, itemData.name, itemData.name, new LanguageManager.ComponentPlaceholder[0]));
        }
        if (!itemData.lore.isEmpty()) {
            ArrayList lore = new ArrayList();
            itemData.lore.forEach(line -> lore.add(this.langManager.getMessageFor(player, (String)line, (String)line, new LanguageManager.ComponentPlaceholder[0])));
            meta.lore(lore);
        }
        itemData.enchantments.forEach((enchantName, level) -> {
            Enchantment enchant = Enchantment.getByName((String)enchantName.toUpperCase());
            if (enchant != null) {
                meta.addEnchant(enchant, level.intValue(), true);
            }
        });
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createNavItem(Material material, String messageKey, String def, Player player, String itemType) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(player, messageKey, def, new LanguageManager.ComponentPlaceholder[0]));
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)this.plugin, ITEM_TYPE_KEY), PersistentDataType.STRING, (Object)itemType);
        if ("CLOSE".equals(itemType)) {
            container.set(new NamespacedKey((Plugin)this.plugin, GUI_IDENTIFIER_KEY), PersistentDataType.STRING, (Object)GUI_IDENTIFIER_VALUE);
        }
        item.setItemMeta(meta);
        return item;
    }

    private void applyMeta(ItemStack item, Player player, String key, String def, LanguageManager.ComponentPlaceholder ... placeholders) {
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(player, key, def, placeholders));
        for (LanguageManager.ComponentPlaceholder ph : placeholders) {
            if (!"lore".equals(ph.placeholder())) continue;
            String[] parts = ph.value().split("\\|", 2);
            if (parts.length != 2) break;
            meta.lore(List.of(this.langManager.getMessageFor(player, parts[0], parts[1], new LanguageManager.ComponentPlaceholder[0])));
            break;
        }
        item.setItemMeta(meta);
    }

    private boolean canClaimDay(Set<Integer> claimedDays, int day) {
        for (int i = 1; i < day; ++i) {
            if (claimedDays.contains(i)) continue;
            return false;
        }
        return true;
    }

    private boolean hasNextPage(int currentPage) {
        return this.config.rewards.values().stream().anyMatch(r -> r.page > currentPage);
    }

    private DailyReward.RewardItem getRewardItem(int day) {
        DailyReward reward = this.config.rewards.get(day);
        return reward != null && !reward.items.isEmpty() ? reward.items.get(0) : null;
    }

    private void sendMessage(Player player, String key, String def, LanguageManager.ComponentPlaceholder ... placeholders) {
        player.sendMessage(this.langManager.getMessageFor(player, key, def, placeholders));
    }
}

