/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.WorldListConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class WorldListCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.worldlist";
    private final PlayerLanguageManager langManager;
    private final WorldListConfig config;

    public WorldListCommand(PlayerLanguageManager langManager, WorldListConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.worldlist.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.worldlist.header", "<gold>========== Worlds ==========", new LanguageManager.ComponentPlaceholder[0]));
        for (World world : Bukkit.getWorlds()) {
            String name = world.getName();
            int loadedChunks = world.getLoadedChunks().length;
            int entityCount = world.getEntities().size();
            int playerCount = world.getPlayers().size();
            String status = this.langManager.getString(String.valueOf(player), "commands.worldlist.status-loaded", "<green>Loaded", new LanguageManager.ComponentPlaceholder[0]);
            Component entry = this.langManager.getMessageFor(player, "commands.worldlist.entry", "<yellow>{world} <gray>({status}) <white>- Chunks: {chunks}, Entities: {entities}, Players: {players}", LanguageManager.ComponentPlaceholder.of("{world}", name), LanguageManager.ComponentPlaceholder.of("{status}", status), LanguageManager.ComponentPlaceholder.of("{chunks}", String.valueOf(loadedChunks)), LanguageManager.ComponentPlaceholder.of("{entities}", String.valueOf(entityCount)), LanguageManager.ComponentPlaceholder.of("{players}", String.valueOf(playerCount)));
            sender.sendMessage(entry);
        }
        return true;
    }
}

