/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.WorldConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class WorldCommand
implements CommandExecutor {
    private static final String PERMISSION_NODE = "essc.command.world";
    private final PlayerLanguageManager langManager;
    private final WorldConfig config;

    public WorldCommand(PlayerLanguageManager langManager, WorldConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.world.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION_NODE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.world.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_NODE)));
            return true;
        }
        if (args.length > 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.world.usage", "<red>Usage: /world", LanguageManager.ComponentPlaceholder.of("{player}", player.getName())));
            return true;
        }
        player.sendMessage(this.langManager.getMessageFor(player, "commands.world.current", "<green>You are in world: <yellow>{world}", LanguageManager.ComponentPlaceholder.of("{player}", player.getName()), LanguageManager.ComponentPlaceholder.of("{world}", player.getWorld().getName())));
        return true;
    }
}

