/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.WhoisConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class WhoisCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.whois";
    private final PlayerLanguageManager langManager;
    private final WhoisConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;

    public WhoisCommand(PlayerLanguageManager langManager, WhoisConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player senderPlayer;
        Player player = senderPlayer = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(senderPlayer, "commands.whois.no-permission", "You need permission {permission}!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            sender.sendMessage(message.toString());
            return true;
        }
        if (args.length != 1) {
            Component message = this.langManager.getMessageFor(senderPlayer, "commands.whois.usage", "Usage: /whois <player>", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            Component message = this.langManager.getMessageFor(senderPlayer, "commands.whois.target-not-found", "Player not found.", LanguageManager.ComponentPlaceholder.of("{target}", args[0]));
            sender.sendMessage(message.toString());
            return true;
        }
        Component header = this.langManager.getMessageFor(senderPlayer, "commands.whois.info-header", "Player info:", new LanguageManager.ComponentPlaceholder[0]);
        sender.sendMessage(header.toString());
        Component nameMsg = this.langManager.getMessageFor(senderPlayer, "commands.whois.info-name", "Name: {name}", LanguageManager.ComponentPlaceholder.of("{name}", target.getName()));
        sender.sendMessage(nameMsg.toString());
        Component healthMsg = this.langManager.getMessageFor(senderPlayer, "commands.whois.info-health", "Health: {health}", LanguageManager.ComponentPlaceholder.of("{health}", String.valueOf(target.getHealth())));
        sender.sendMessage(healthMsg.toString());
        Component locMsg = this.langManager.getMessageFor(senderPlayer, "commands.whois.info-location", "Location: {location}", LanguageManager.ComponentPlaceholder.of("{location}", target.getLocation().toVector().toString()));
        sender.sendMessage(locMsg.toString());
        this.trackUsage(target.getUniqueId(), "lookup", 1);
        return true;
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "whois", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "whois", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "whois", "last_type", type);
            this.dataStorage.setState(playerId, "whois", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

