/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.WeatherConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class WeatherCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.weather";
    private static final String PERMISSION_CLEAR = "essc.command.weather.clear";
    private static final String PERMISSION_RAIN = "essc.command.weather.rain";
    private static final String PERMISSION_THUNDER = "essc.command.weather.thunderstorm";
    private final PlayerLanguageManager langManager;
    private final WeatherConfig config;
    private final CommandDataStorage dataStorage;

    public WeatherCommand(PlayerLanguageManager langManager, WeatherConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String type;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.weather.only-player", "<#B22222>\u274c Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission", "<#B22222>\u274c You need permission <#FFD900>{permission}</#FFD900>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0 || args.length > 1 || args[0].equalsIgnoreCase("help")) {
            this.sendHelpMessage(player);
            return true;
        }
        World world = player.getWorld();
        switch (type = args[0].toLowerCase()) {
            case "clear": {
                if (!player.hasPermission(PERMISSION_CLEAR)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission-sub", "<#B22222>\u274c You need permission <#FFD900>{subpermission}</#FFD900>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_CLEAR)));
                    return true;
                }
                world.setStorm(false);
                world.setThundering(false);
                world.setWeatherDuration(this.config.durationTicks());
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.clear", "<#3BB302>\u2714 Weather set to clear for <white>{duration} <#3BB302>\u2714 seconds.", LanguageManager.ComponentPlaceholder.of("{duration}", this.config.durationTicks() / 20)));
                break;
            }
            case "rain": {
                if (!player.hasPermission(PERMISSION_RAIN)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission-sub", "<#B22222>\u274c You need permission <#FFD900>{subpermission}</#FFD900>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_RAIN)));
                    return true;
                }
                world.setStorm(true);
                world.setThundering(false);
                world.setWeatherDuration(this.config.durationTicks());
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.rain", "<#1E90FF>Weather set to rain for <white>{duration} <#1E90FF>seconds.", LanguageManager.ComponentPlaceholder.of("{duration}", this.config.durationTicks() / 20)));
                break;
            }
            case "thunderstorm": {
                if (!player.hasPermission(PERMISSION_THUNDER)) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.no-permission-sub", "<#B22222>\u274c You need permission <#FFD900>{subpermission}</#FFD900>!", LanguageManager.ComponentPlaceholder.of("{subpermission}", PERMISSION_THUNDER)));
                    return true;
                }
                world.setStorm(true);
                world.setThundering(true);
                world.setWeatherDuration(this.config.durationTicks());
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.thunderstorm", "<#FFD900>Weather set to thunderstorm for <white>{duration} <#FFD900>seconds.", LanguageManager.ComponentPlaceholder.of("{duration}", this.config.durationTicks() / 20)));
                break;
            }
            default: {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.weather.invalid-type", "<#B22222>\u274c Invalid weather type. Use: clear, rain, or thunderstorm.", new LanguageManager.ComponentPlaceholder[0]));
                this.sendHelpMessage(player);
                return true;
            }
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.setState(playerId, "weather", "last_type", type);
        this.dataStorage.getState(playerId, "weather", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "weather", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "weather", "last_used", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }

    private void sendHelpMessage(Player player) {
        Component help = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(this.langManager.getMessageFor(player, "commands.weather.help.header", "<#FFD900><bold>=== Weather Command Help ===</bold></#FFD900>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.weather.help.description", "<gray>Change the weather in your current world for a set duration.</gray>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.weather.help.usage", "<#FFD900>Usage:</#FFD900> <white>/weather <type></white>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.weather.help.types.header", "<#FFD900>Available Weather Types:</#FFD900>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline());
        help = help.append(player.hasPermission(PERMISSION_CLEAR) ? this.langManager.getMessageFor(player, "commands.weather.help.types.clear", "  <white>\u2022 clear</white> <gray>- Set weather to sunny</gray>", new LanguageManager.ComponentPlaceholder[0]) : this.langManager.getMessageFor(player, "commands.weather.help.types.clear.no-perm", "  <dark_gray>\u2022 clear</dark_gray> <gray>- No permission</gray>", new LanguageManager.ComponentPlaceholder[0])).append(Component.newline());
        help = help.append(player.hasPermission(PERMISSION_RAIN) ? this.langManager.getMessageFor(player, "commands.weather.help.types.rain", "  <white>\u2022 rain</white> <gray>- Set weather to rain</gray>", new LanguageManager.ComponentPlaceholder[0]) : this.langManager.getMessageFor(player, "commands.weather.help.types.rain.no-perm", "  <dark_gray>\u2022 rain</dark_gray> <gray>- No permission</gray>", new LanguageManager.ComponentPlaceholder[0])).append(Component.newline());
        help = help.append(player.hasPermission(PERMISSION_THUNDER) ? this.langManager.getMessageFor(player, "commands.weather.help.types.thunderstorm", "  <white>\u2022 thunderstorm</white> <gray>- Set weather to thunderstorm</gray>", new LanguageManager.ComponentPlaceholder[0]) : this.langManager.getMessageFor(player, "commands.weather.help.types.thunderstorm.no-perm", "  <dark_gray>\u2022 thunderstorm</dark_gray> <gray>- No permission</gray>", new LanguageManager.ComponentPlaceholder[0])).append(Component.newline());
        help = help.append(this.langManager.getMessageFor(player, "commands.weather.help.duration", "<#FFD900>Duration:</#FFD900> <white>{duration} seconds</white>", LanguageManager.ComponentPlaceholder.of("{duration}", this.config.durationTicks() / 20))).append(Component.newline());
        help = help.append(this.langManager.getMessageFor(player, "commands.weather.help.footer", "<dark_gray>Use /weather help to see this message again.</dark_gray>", new LanguageManager.ComponentPlaceholder[0]));
        player.sendMessage(help);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            String partial = args[0].toLowerCase();
            if ("help".startsWith(partial)) {
                options.add("help");
            }
            if (player.hasPermission(PERMISSION_CLEAR) && "clear".startsWith(partial)) {
                options.add("clear");
            }
            if (player.hasPermission(PERMISSION_RAIN) && "rain".startsWith(partial)) {
                options.add("rain");
            }
            if (player.hasPermission(PERMISSION_THUNDER) && "thunderstorm".startsWith(partial)) {
                options.add("thunderstorm");
            }
            return options;
        }
        return List.of();
    }
}

