/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.CommandModule;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.warp.WarpManager;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpsCommand
extends CommandModule
implements CommandExecutor {
    private final WarpManager warpManager;

    public WarpsCommand(WarpManager warpManager, PlayerLanguageManager langManager, CommandDataStorage commandStorage) {
        super(commandStorage, langManager);
        this.warpManager = warpManager;
    }

    @Override
    protected String getCommandName() {
        return "warps";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only-players", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("essc.command.warps")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.warps")));
            return true;
        }
        this.warpManager.getAllWarps().thenAccept(warps -> {
            if (warps.isEmpty()) {
                player.sendMessage(this.langManager.getMessageFor(player, "warps.empty", "<yellow>No warps have been set!", new LanguageManager.ComponentPlaceholder[0]));
                return;
            }
            player.sendMessage(this.langManager.getMessageFor(player, "warps.header", "<gold>------[ Warps ]------", new LanguageManager.ComponentPlaceholder[0]));
            warps.keySet().forEach(warp -> {
                Component line = this.langManager.getMessageFor(player, "warps.entry", "<green>{warp}", LanguageManager.ComponentPlaceholder.of("{warp}", warp));
                player.sendMessage(line);
            });
            player.sendMessage(this.langManager.getMessageFor(player, "warps.footer", "<gold>-------------------", new LanguageManager.ComponentPlaceholder[0]));
        });
        return true;
    }
}

