/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.CommandModule;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.warp.WarpManager;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WarpTeleportCommand
extends CommandModule
implements CommandExecutor {
    private final WarpManager warpManager;
    private final JavaPlugin plugin;

    public WarpTeleportCommand(JavaPlugin plugin, WarpManager warpManager, PlayerLanguageManager langManager, CommandDataStorage commandStorage) {
        super(commandStorage, langManager);
        this.plugin = plugin;
        this.warpManager = warpManager;
    }

    @Override
    protected String getCommandName() {
        return "warp";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only-players", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "warp.usage", "<red>Usage: <yellow>/warp <name>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!player.hasPermission("essc.command.warp")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.warp")));
            return true;
        }
        String warpName = args[0].toLowerCase();
        this.plugin.getLogger().info("Player " + player.getName() + " attempting to warp to '" + warpName + "'");
        this.checkCooldownAndTeleport(player, warpName);
        return true;
    }

    private void checkCooldownAndTeleport(Player player, String warpName) {
        if (player.hasPermission("essc.command.warp.bypass-cooldown")) {
            this.teleport(player, warpName);
            return;
        }
        UUID uuid = player.getUniqueId();
        long now = Instant.now().getEpochSecond();
        String cooldownKey = "last-warp";
        ((CompletableFuture)this.storage.getState(uuid, this.getCommandName(), cooldownKey).thenApply(opt -> opt.map(Long::parseLong).orElse(0L))).thenCompose(lastUsed -> {
            long elapsed = now - lastUsed;
            if (elapsed < this.warpManager.getCooldown().getSeconds()) {
                long remaining = this.warpManager.getCooldown().getSeconds() - elapsed;
                player.sendMessage(this.langManager.getMessageFor(player, "warp.cooldown-active", "<red>Please wait <yellow>{time}</yellow> seconds before warping again.", LanguageManager.ComponentPlaceholder.of("{time}", String.valueOf(remaining))));
                return CompletableFuture.completedFuture(null);
            }
            return this.storage.setState(uuid, this.getCommandName(), cooldownKey, String.valueOf(now)).thenCompose(v -> this.teleport(player, warpName));
        });
    }

    private CompletableFuture<Void> teleport(Player player, String warpName) {
        this.plugin.getLogger().info("Fetching warp '" + warpName + "' from database...");
        return ((CompletableFuture)this.warpManager.getWarp(warpName).thenAccept(optionalLocation -> {
            this.plugin.getLogger().info("Database returned: " + String.valueOf(optionalLocation));
            if (optionalLocation.isPresent()) {
                Optional loc = (Optional)optionalLocation.get();
                if (loc.isPresent()) {
                    Location location = (Location)loc.get();
                    this.plugin.getLogger().info("Warp location found: " + String.valueOf(location) + " in world " + String.valueOf(location.getWorld()));
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                        try {
                            if (location.getWorld() == null) {
                                player.sendMessage("Warp world is not loaded!");
                                this.plugin.getLogger().warning("Warp '" + warpName + "' has null world!");
                                return;
                            }
                            boolean success = player.teleport(location);
                            this.plugin.getLogger().info("Teleport successful: " + success);
                            if (success) {
                                player.sendMessage(this.langManager.getMessageFor(player, "warp.success", "<green>Teleported to warp <yellow>{warp}</yellow>!", LanguageManager.ComponentPlaceholder.of("{warp}", warpName)));
                            } else {
                                player.sendMessage("Teleport failed! Location might be unsafe.");
                            }
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().severe("Error teleporting player: " + e.getMessage());
                            e.printStackTrace();
                            player.sendMessage("\u00a7cError teleporting to warp!");
                        }
                    });
                } else {
                    this.plugin.getLogger().warning("Warp '" + warpName + "' exists but location is corrupted (null)");
                    player.sendMessage("\u00a7cWarp location is corrupted! Contact an admin.");
                }
            } else {
                this.plugin.getLogger().info("Warp '" + warpName + "' not found in database");
                player.sendMessage(this.langManager.getMessageFor(player, "warp.not-found", "<red>Warp <yellow>{warp}</yellow> not found.", LanguageManager.ComponentPlaceholder.of("{warp}", warpName)));
            }
        })).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to fetch warp '" + warpName + "': " + ex.getMessage());
            ex.printStackTrace();
            player.sendMessage("\u00a7cError accessing warp data!");
            return null;
        });
    }
}

