/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.CommandModule;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.warp.WarpManager;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpSetCommand
extends CommandModule
implements CommandExecutor {
    private final WarpManager warpManager;

    public WarpSetCommand(WarpManager warpManager, PlayerLanguageManager langManager, CommandDataStorage commandStorage) {
        super(commandStorage, langManager);
        this.warpManager = warpManager;
    }

    @Override
    protected String getCommandName() {
        return "setwarp";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only-players", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.setwarp.usage", "<red>Usage: <yellow>/setwarp <name>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!player.hasPermission("essc.command.setwarp")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.setwarp")));
            return true;
        }
        String warpName = args[0].toLowerCase();
        int maxWarps = this.warpManager.getMaxWarpsForPlayer(player);
        this.warpManager.getWarpCountByCreator(player.getUniqueId()).thenAccept(playerWarpCount -> {
            if (playerWarpCount >= maxWarps) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.setwarp.limit-reached", "<red>You have reached your warp limit of <yellow>{limit}</yellow>!", LanguageManager.ComponentPlaceholder.of("{limit}", String.valueOf(maxWarps))));
                return;
            }
            ((CompletableFuture)this.warpManager.exists(warpName).thenCompose(exists -> {
                if (!exists.booleanValue()) {
                    return CompletableFuture.completedFuture(true);
                }
                return this.warpManager.getCreator(warpName).thenApply(optCreator -> {
                    if (optCreator.isEmpty() || !((UUID)optCreator.get()).equals(player.getUniqueId())) {
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.setwarp.already-exists", "<red>Warp <yellow>{warp}</yellow> already exists.", LanguageManager.ComponentPlaceholder.of("{warp}", warpName)));
                        return false;
                    }
                    return true;
                });
            })).thenCompose(canCreate -> {
                if (!canCreate.booleanValue()) {
                    return CompletableFuture.completedFuture(null);
                }
                Location loc = player.getLocation();
                return this.warpManager.addWarp(warpName, loc, player.getUniqueId()).thenRun(() -> player.sendMessage(this.langManager.getMessageFor(player, "commands.setwarp.success", "<green>Created warp <yellow>{warp}</yellow>!", LanguageManager.ComponentPlaceholder.of("{warp}", warpName))));
            });
        });
        return true;
    }
}

