/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.VanishConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class VanishCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.vanish";
    private static final String COMMAND_NAME = "vanish";
    private static final Set<UUID> vanishedCache = ConcurrentHashMap.newKeySet();
    private final PlayerLanguageManager langManager;
    private final VanishConfig config;
    private final CommandDataStorage dataStorage;
    private final JavaPlugin plugin;

    public VanishCommand(JavaPlugin plugin, PlayerLanguageManager langManager, VanishConfig config, CommandDataStorage dataStorage) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.vanish.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.vanish.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        UUID playerId = player.getUniqueId();
        if (vanishedCache.contains(playerId)) {
            vanishedCache.remove(playerId);
            this.dataStorage.deleteState(playerId, COMMAND_NAME, "enabled");
            Bukkit.getOnlinePlayers().forEach(p -> p.showPlayer((Plugin)this.plugin, player));
            player.sendMessage(this.langManager.getMessageFor(player, "commands.vanish.visible", "<green>You are now visible to all players.", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            vanishedCache.add(playerId);
            this.dataStorage.setState(playerId, COMMAND_NAME, "enabled", "true");
            if (!this.config.showVanishedInTabList()) {
                Bukkit.getOnlinePlayers().forEach(p -> p.hidePlayer((Plugin)this.plugin, player));
            }
            player.sendMessage(this.langManager.getMessageFor(player, "commands.vanish.vanished", "<green>You are now vanished.", new LanguageManager.ComponentPlaceholder[0]));
        }
        return true;
    }

    public static boolean isVanished(UUID playerId) {
        return vanishedCache.contains(playerId);
    }

    public void loadPlayerState(UUID playerId) {
        this.dataStorage.getState(playerId, COMMAND_NAME, "enabled").thenAccept(opt -> {
            if (opt.isPresent() && "true".equals(opt.get())) {
                vanishedCache.add(playerId);
            }
        });
    }

    public void unloadPlayerState(UUID playerId) {
        vanishedCache.remove(playerId);
    }
}

