/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.CommandModule;
import net.godlycow.org.commands.impl.MuteCommand;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnmuteCommand
extends CommandModule
implements CommandExecutor {
    private final PlayerLanguageManager langManager;
    private final MuteCommand muteCommand;

    public UnmuteCommand(PlayerLanguageManager langManager, CommandDataStorage commandStorage, MuteCommand muteCommand) {
        super(commandStorage, langManager);
        this.langManager = langManager;
        this.muteCommand = muteCommand;
    }

    @Override
    protected String getCommandName() {
        return "unmute";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("essc.command.unmute")) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.unmute")));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.unmute.usage", "<red>Usage: <yellow>/unmute <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target.getName() == null) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.unmute.player-not-found", "<red>Player <#00ffff>{player}</#00ffff> not found.", LanguageManager.ComponentPlaceholder.of("{player}", targetName)));
            return true;
        }
        this.muteCommand.isMuted(target.getUniqueId()).thenAccept(isMuted -> {
            if (!isMuted.booleanValue()) {
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.unmute.not-muted", "<red><yellow>{player}</yellow> is not currently muted.", LanguageManager.ComponentPlaceholder.of("{player}", targetName)));
                return;
            }
            this.muteCommand.unmute(target.getUniqueId()).thenRun(() -> {
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.unmute.unmuted", "<green>Successfully unmuted <#00ffff>{player}</#00ffff>", LanguageManager.ComponentPlaceholder.of("{player}", targetName)));
                if (target.isOnline()) {
                    Player player = target.getPlayer();
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.unmute.notify", "<green>You have been unmuted!", new LanguageManager.ComponentPlaceholder[0]));
                }
            });
        });
        return true;
    }
}

