/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.godlycow.org.commands.config.UnloadWorldConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public final class UnloadWorldCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.unloadworld";
    private final PlayerLanguageManager langManager;
    private final UnloadWorldConfig config;

    public UnloadWorldCommand(PlayerLanguageManager langManager, UnloadWorldConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.unloadworld.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.unloadworld.usage", "<red>Usage: /unloadworld <world>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String worldName = args[0];
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.unloadworld.not-found", "<red>World <yellow>{world}</yellow> not found!", LanguageManager.ComponentPlaceholder.of("{world}", worldName)));
            return true;
        }
        if (!Bukkit.unloadWorld((World)world, (boolean)true)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.unloadworld.failed", "<red>Failed to unload world <yellow>{world}</yellow>!", LanguageManager.ComponentPlaceholder.of("{world}", worldName)));
            return true;
        }
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.unloadworld.success", "<green>Successfully unloaded world <yellow>{world}</yellow>.", LanguageManager.ComponentPlaceholder.of("{world}", worldName)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1 && sender.hasPermission(PERMISSION)) {
            ArrayList<String> worldNames = new ArrayList<String>();
            for (World world : Bukkit.getWorlds()) {
                worldNames.add(world.getName());
            }
            String input = args[0].toLowerCase();
            worldNames.removeIf(name -> !name.toLowerCase().startsWith(input));
            return worldNames;
        }
        return Collections.emptyList();
    }
}

