/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.ban.storage.BanStorage;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.CommandModule;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnbanCommand
extends CommandModule
implements CommandExecutor {
    private final PlayerLanguageManager langManager;
    private final BanStorage storage;

    public UnbanCommand(PlayerLanguageManager langManager, CommandDataStorage commandStorage, BanStorage storage) {
        super(commandStorage, langManager);
        this.langManager = langManager;
        this.storage = storage;
    }

    @Override
    protected String getCommandName() {
        return "unban";
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("essc.command.unban")) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.unban")));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "unban.usage", "<red>Usage: <yellow>/unban <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String playerName = args[0];
        ((CompletableFuture)this.storage.getUUIDFromName(playerName).thenCompose(optUuid -> {
            if (optUuid.isEmpty()) {
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "unban.player-not-found", "<red>Could not find banned player with name '<yellow>{player}</yellow>'.", LanguageManager.ComponentPlaceholder.of("{player}", playerName)));
                return CompletableFuture.completedFuture(null);
            }
            UUID uuid = (UUID)optUuid.get();
            return this.storage.isBanned(uuid).thenCompose(isBanned -> {
                if (!isBanned.booleanValue()) {
                    sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "unban.not-banned", "<yellow>{player}</yellow> is not currently banned.", LanguageManager.ComponentPlaceholder.of("{player}", playerName)));
                    return CompletableFuture.completedFuture(null);
                }
                return this.storage.unbanPlayer(uuid).thenApply(v -> playerName);
            });
        })).thenAccept(result -> {
            if (result != null) {
                sender.sendMessage(this.langManager.getMessageFor(sender instanceof Player ? (Player)sender : null, "unban.success", "<green>{player}</green> has been unbanned.", LanguageManager.ComponentPlaceholder.of("{player}", result)));
            }
        });
        return true;
    }
}

