/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.TrackConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class TrackCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.track";
    private final PlayerLanguageManager langManager;
    private final TrackConfig config;
    private final CommandDataStorage dataStorage;

    public TrackCommand(PlayerLanguageManager langManager, TrackConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.track.only-players", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.track.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.track.usage", "<red>Usage: <white>/track <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.track.not-found", "<red>Player <yellow>{target}</yellow> not found.", LanguageManager.ComponentPlaceholder.of("{target}", args[0])));
            return true;
        }
        Location targetLoc = target.getLocation();
        player.setCompassTarget(targetLoc);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.track.success", "<green>Now tracking <yellow>{target}</yellow>. Compass updated.", LanguageManager.ComponentPlaceholder.of("{target}", target.getName())));
        UUID playerId = player.getUniqueId();
        String trackingData = String.valueOf(target.getUniqueId()) + ":" + System.currentTimeMillis();
        this.dataStorage.setState(playerId, "track", "last_target", trackingData).thenAccept(v -> this.dataStorage.getState(playerId, "track", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "track", "usage_count", String.valueOf(count + 1));
        }));
        return true;
    }
}

