/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.godlycow.org.commands.config.TpConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class TpCommand
implements TabExecutor {
    private static final String PERMISSION = "essc.command.tp";
    private final PlayerLanguageManager langManager;
    private final TpConfig config;

    public TpCommand(PlayerLanguageManager langManager, TpConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.tp.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.usage", "<red>Usage: /tp <player|x y z>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length == 1) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.player-not-found", "<red>Player not found: <yellow>{player}</yellow>", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
                return true;
            }
            player.teleport((Entity)target);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.success", "<green>Teleported to <white>{player}</white>.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
            return true;
        }
        if (args.length == 2) {
            Player p1 = Bukkit.getPlayer((String)args[0]);
            Player p2 = Bukkit.getPlayer((String)args[1]);
            if (p1 == null || p2 == null) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.player-not-found", "<red>Player not found.", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
            p1.teleport((Entity)p2);
            player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.success-other", "<green>Teleported <white>{p1}</white> to <white>{p2}</white>.", LanguageManager.ComponentPlaceholder.of("{p1}", p1.getName()), LanguageManager.ComponentPlaceholder.of("{p2}", p2.getName())));
            return true;
        }
        int index = 0;
        Player targetPlayer = player;
        if (args.length != 3 && args.length != 5) {
            if (args.length == 4 || args.length == 6) {
                Player specified = Bukkit.getPlayer((String)args[0]);
                if (specified == null) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.player-not-found", "<red>Player not found: <yellow>{player}</yellow>", LanguageManager.ComponentPlaceholder.of("{player}", args[0])));
                    return true;
                }
                targetPlayer = specified;
                index = 1;
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.usage", "<red>Usage: /tp <player> <player|coords>", new LanguageManager.ComponentPlaceholder[0]));
                return true;
            }
        }
        Location origin = targetPlayer.getLocation();
        World world = origin.getWorld();
        double x = this.parseCoord(origin.getX(), args[index]);
        double y = this.parseCoord(origin.getY(), args[index + 1]);
        double z = this.parseCoord(origin.getZ(), args[index + 2]);
        float yaw = origin.getYaw();
        float pitch = origin.getPitch();
        if (args.length - index >= 5) {
            yaw = this.parseRotation(origin.getYaw(), args[index + 3]);
            pitch = this.parseRotation(origin.getPitch(), args[index + 4]);
        }
        Location newLoc = new Location(world, x, y, z, yaw, pitch);
        targetPlayer.teleport(newLoc);
        if (targetPlayer.equals((Object)player)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.success-coords", "<green>Teleported to <white>{x} {y} {z}</white>.", LanguageManager.ComponentPlaceholder.of("{x}", "" + x), LanguageManager.ComponentPlaceholder.of("{y}", "" + y), LanguageManager.ComponentPlaceholder.of("{z}", "" + z)));
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.tp.success-other", "<green>Teleported <white>{p1}</white> to coordinates.", LanguageManager.ComponentPlaceholder.of("{p1}", targetPlayer.getName())));
        }
        return true;
    }

    private double parseCoord(double base, String input) {
        if (input.startsWith("~")) {
            if (input.equals("~")) {
                return base;
            }
            return base + Double.parseDouble(input.substring(1));
        }
        if (input.startsWith("^")) {
            return base;
        }
        return Double.parseDouble(input);
    }

    private float parseRotation(float base, String input) {
        if (input.startsWith("~")) {
            if (input.equals("~")) {
                return base;
            }
            return base + Float.parseFloat(input.substring(1));
        }
        return Float.parseFloat(input);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 || args.length == 2) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
                list.add(p.getName());
            }
            return list;
        }
        if (args.length >= 3 && args.length <= 6) {
            list.add("~");
            list.add("~ ~");
            list.add("~ ~ ~");
            return list;
        }
        return Collections.emptyList();
    }
}

