/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.tpa.TPAConfig;
import net.godlycow.org.tpa.model.TPARequest;
import net.godlycow.org.tpa.storage.TPAStorage;
import net.godlycow.org.tpa.trigger.TPAListener;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TPACommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final TPAStorage storage;
    private final TPAConfig config;
    private final TPAListener listener;
    private final Map<UUID, Long> activeCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Set<UUID> activeToggles = ConcurrentHashMap.newKeySet();

    public TPACommand(JavaPlugin plugin, PlayerLanguageManager langManager, TPAStorage storage, TPAConfig config, TPAListener listener) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
        this.listener = listener;
        this.loadInitialData();
    }

    private void loadInitialData() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> Bukkit.getOnlinePlayers().forEach(player -> this.storage.getToggle(player.getUniqueId()).thenAccept(toggle -> {
            if (toggle.booleanValue()) {
                this.activeToggles.add(player.getUniqueId());
            }
        })));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        String name = cmd.getName().toLowerCase();
        if (!player.hasPermission("essc.command.tpa.bypass.cooldown")) {
            this.storage.getCooldown(player.getUniqueId()).thenAccept(cooldownTime -> {
                long now = System.currentTimeMillis();
                int cd = this.config.cooldown;
                if (cooldownTime > 0L && now - cooldownTime < (long)cd * 1000L) {
                    long remaining = (long)cd - TimeUnit.MILLISECONDS.toSeconds(now - cooldownTime);
                    Component msg = this.langManager.getMessageFor(player, "commands.tpa.cooldown", "<red>Please wait {time} seconds before using TPA again.", LanguageManager.ComponentPlaceholder.of("{time}", String.valueOf(remaining)));
                    player.sendMessage(msg);
                    return;
                }
                this.processCommand(player, name, args);
            });
            return true;
        }
        return this.processCommand(player, name, args);
    }

    private boolean processCommand(Player player, String name, String[] args) {
        String permission = "essc.command." + name.toLowerCase();
        if (!player.hasPermission(permission)) {
            return true;
        }
        switch (name) {
            case "tpa": {
                if (args.length == 0) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.usage.tpa", "<red>Usage: /tpa <player>", new LanguageManager.ComponentPlaceholder[0]));
                    return false;
                }
                this.handleTpa(player, args[0], false);
                break;
            }
            case "tpahere": {
                if (args.length == 0) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.usage.tpahere", "<red>Usage: /tpahere <player>", new LanguageManager.ComponentPlaceholder[0]));
                    return false;
                }
                this.handleTpa(player, args[0], true);
                break;
            }
            case "tpaccept": {
                this.handleAcceptDeny(player, args.length > 0 ? args[0] : null, true);
                break;
            }
            case "tpdeny": {
                this.handleAcceptDeny(player, args.length > 0 ? args[0] : null, false);
                break;
            }
            case "tpacancel": {
                this.handleCancel(player, args.length > 0 ? args[0] : null);
                break;
            }
            case "tpall": {
                this.handleTpall(player);
                break;
            }
            case "tpatoggle": {
                this.handleToggle(player);
                break;
            }
            case "tpainfo": {
                this.handleInfo(player);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void handleTpa(Player sender, String targetName, boolean here) {
        double cost;
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null || !target.isOnline()) {
            Component msg = this.langManager.getMessageFor(sender, "commands.tpa.no-player", "<red>Player {player} not found.", LanguageManager.ComponentPlaceholder.of("{player}", targetName));
            sender.sendMessage(msg);
            return;
        }
        if (sender.equals((Object)target)) {
            Component msg = this.langManager.getMessageFor(sender, "commands.tpa.cannot-tpa-self", "<red>You cannot send a TPA request to yourself.", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(msg);
            return;
        }
        if (!this.validateRequest(sender, target)) {
            return;
        }
        double d = cost = here ? this.config.costTpahere : this.config.costTpa;
        if (cost > 0.0 && !this.chargePlayer(sender, cost)) {
            return;
        }
        TPARequest request = TPARequest.create(sender.getUniqueId(), target.getUniqueId(), here, cost);
        this.storage.saveRequest(request).thenRun(() -> {
            Component senderMsg = this.langManager.getMessageFor(sender, here ? "commands.tpa.request-sent-here" : "commands.tpa.request-sent", "<green>TPA request sent to {player}.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()));
            sender.sendMessage(senderMsg);
            Component targetMsg = this.langManager.getMessageFor(target, here ? "commands.tpa.request-received-here" : "commands.tpa.request-received", "<green>{player} wants to teleport to you. Use <yellow>/tpaccept {player}</yellow> or <red>/tpdeny {player}</red>", LanguageManager.ComponentPlaceholder.of("{player}", sender.getName()));
            target.sendMessage(targetMsg);
            this.startTimeout(request);
            this.storage.saveCooldown(sender.getUniqueId(), System.currentTimeMillis());
        });
    }

    private void handleAcceptDeny(Player player, String senderName, boolean accept) {
        this.storage.getActiveRequests(player.getUniqueId()).thenAccept(requests -> {
            TPARequest request;
            if (requests.isEmpty()) {
                Component msg = this.langManager.getMessageFor(player, "commands.tpa.no-request", "<red>You have no pending TPA requests.", new LanguageManager.ComponentPlaceholder[0]);
                player.sendMessage(msg);
                return;
            }
            TPARequest tPARequest = request = senderName != null ? this.findRequestByName((List<TPARequest>)requests, senderName) : (TPARequest)requests.get(requests.size() - 1);
            if (request == null && senderName != null) {
                Component msg = this.langManager.getMessageFor(player, "commands.tpa.no-request-from-player", "<red>No pending request from {player}.", LanguageManager.ComponentPlaceholder.of("{player}", senderName));
                player.sendMessage(msg);
                return;
            }
            if (request == null) {
                Component msg = this.langManager.getMessageFor(player, "commands.tpa.no-request", "<red>You have no pending TPA requests.", new LanguageManager.ComponentPlaceholder[0]);
                player.sendMessage(msg);
                return;
            }
            this.storage.removeRequest(request.senderId, request.targetId).thenRun(() -> {
                if (accept) {
                    this.acceptRequest(request);
                } else {
                    this.denyRequest(request);
                }
            });
        });
    }

    private void handleCancel(Player sender, String targetName) {
        if (targetName == null) {
            this.storage.getActiveRequestsForSender(sender.getUniqueId()).thenAccept(requests -> {
                if (requests.isEmpty()) {
                    Component msg = this.langManager.getMessageFor(sender, "commands.tpa.no-requests-sent", "<red>You have no pending TPA requests to cancel.", new LanguageManager.ComponentPlaceholder[0]);
                    sender.sendMessage(msg);
                    return;
                }
                requests.forEach(req -> this.storage.removeRequest(req.senderId, req.targetId).thenRun(() -> {
                    Player target = Bukkit.getPlayer((UUID)req.targetId);
                    if (target != null) {
                        Component msg = this.langManager.getMessageFor(target, "commands.tpa.request-cancelled-target", "<yellow>{player} cancelled their TPA request.", LanguageManager.ComponentPlaceholder.of("{player}", sender.getName()));
                        target.sendMessage(msg);
                    }
                }));
                Component msg = this.langManager.getMessageFor(sender, "commands.tpa.request-cancelled-all", "<green>Cancelled all your TPA requests.", new LanguageManager.ComponentPlaceholder[0]);
                sender.sendMessage(msg);
            });
        } else {
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null) {
                Component msg = this.langManager.getMessageFor(sender, "commands.tpa.no-player", "<red>Player {player} not found.", LanguageManager.ComponentPlaceholder.of("{player}", targetName));
                sender.sendMessage(msg);
                return;
            }
            this.storage.removeRequest(sender.getUniqueId(), target.getUniqueId()).thenRun(() -> {
                Component senderMsg = this.langManager.getMessageFor(sender, "commands.tpa.request-cancelled", "<green>Cancelled TPA request to {player}.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()));
                sender.sendMessage(senderMsg);
                Component targetMsg = this.langManager.getMessageFor(target, "commands.tpa.request-cancelled-target", "<yellow>{player} cancelled their TPA request.", LanguageManager.ComponentPlaceholder.of("{player}", sender.getName()));
                target.sendMessage(targetMsg);
            });
        }
    }

    private void handleTpall(Player sender) {
        double cost = this.config.costTpall;
        if (cost > 0.0 && !this.chargePlayer(sender, cost)) {
            return;
        }
        int sent = 0;
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target.equals((Object)sender) || this.activeToggles.contains(target.getUniqueId())) continue;
            TPARequest request = TPARequest.create(sender.getUniqueId(), target.getUniqueId(), true, 0.0);
            this.storage.saveRequest(request);
            Component msg = this.langManager.getMessageFor(target, "commands.tpa.request-received-all", "<green>{player} wants everyone to teleport to them. Use <yellow>/tpaccept {player}</yellow>", LanguageManager.ComponentPlaceholder.of("{player}", sender.getName()));
            target.sendMessage(msg);
            this.startTimeout(request);
            ++sent;
        }
        Component senderMsg = this.langManager.getMessageFor(sender, "commands.tpa.request-sent-all", "<green>Sent TPA request to {count} players.", LanguageManager.ComponentPlaceholder.of("{count}", String.valueOf(sent)));
        sender.sendMessage(senderMsg);
        this.storage.saveCooldown(sender.getUniqueId(), System.currentTimeMillis());
    }

    private void handleToggle(Player player) {
        boolean current = this.activeToggles.contains(player.getUniqueId());
        boolean newState = !current;
        this.storage.setToggle(player.getUniqueId(), newState).thenRun(() -> {
            if (newState) {
                this.activeToggles.add(player.getUniqueId());
                Component msg = this.langManager.getMessageFor(player, "commands.tpa.toggle-on", "<green>TPA requests are now <bold>DISABLED</bold>.", new LanguageManager.ComponentPlaceholder[0]);
                player.sendMessage(msg);
            } else {
                this.activeToggles.remove(player.getUniqueId());
                Component msg = this.langManager.getMessageFor(player, "commands.tpa.toggle-off", "<green>TPA requests are now <bold>ENABLED</bold>.", new LanguageManager.ComponentPlaceholder[0]);
                player.sendMessage(msg);
            }
        });
    }

    private void handleInfo(Player player) {
        CompletableFuture.allOf(this.storage.getActiveRequests(player.getUniqueId()), this.storage.getActiveRequestsForSender(player.getUniqueId())).thenAccept(result -> this.storage.getActiveRequests(player.getUniqueId()).thenAccept(incoming -> this.storage.getActiveRequestsForSender(player.getUniqueId()).thenAccept(outgoing -> {
            if (incoming.isEmpty() && outgoing.isEmpty()) {
                Component msg = this.langManager.getMessageFor(player, "commands.tpa.no-request", "<red>You have no pending TPA requests.", new LanguageManager.ComponentPlaceholder[0]);
                player.sendMessage(msg);
            } else {
                if (!incoming.isEmpty()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.tpa.info-incoming-header", "<gold>Incoming requests:", new LanguageManager.ComponentPlaceholder[0]).toString());
                    incoming.forEach(req -> {
                        String senderName = Bukkit.getOfflinePlayer((UUID)req.senderId).getName();
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.tpa.info-request", "<yellow>- {player} ({type})", LanguageManager.ComponentPlaceholder.of("{player}", senderName), LanguageManager.ComponentPlaceholder.of("{type}", req.here ? "TPAHere" : "TPA")).toString());
                    });
                }
                if (!outgoing.isEmpty()) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.tpa.info-outgoing-header", "<gold>Outgoing requests:", new LanguageManager.ComponentPlaceholder[0]).toString());
                    outgoing.forEach(req -> {
                        String targetName = Bukkit.getOfflinePlayer((UUID)req.targetId).getName();
                        player.sendMessage(this.langManager.getMessageFor(player, "commands.tpa.info-request", "<yellow>- {player} ({type})", LanguageManager.ComponentPlaceholder.of("{player}", targetName), LanguageManager.ComponentPlaceholder.of("{type}", req.here ? "TPAHere" : "TPA")).toString());
                    });
                }
            }
        })));
    }

    private boolean validateRequest(Player sender, Player target) {
        if (this.activeToggles.contains(target.getUniqueId())) {
            Component msg = this.langManager.getMessageFor(sender, "commands.tpa.target-toggled", "<red>{player} has TPA disabled.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()));
            sender.sendMessage(msg);
            return false;
        }
        if (!this.config.crossWorld && !sender.getWorld().equals((Object)target.getWorld())) {
            Component msg = this.langManager.getMessageFor(sender, "commands.tpa.crossworld-disabled", "<red>Cross-world teleportation is disabled.", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(msg);
            return false;
        }
        if (this.config.blockedWorlds.contains(target.getWorld().getName())) {
            Component msg = this.langManager.getMessageFor(sender, "commands.tpa.blocked-world", "<red>You cannot teleport to this world.", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(msg);
            return false;
        }
        return true;
    }

    private boolean chargePlayer(Player player, double cost) {
        if (!this.config.economyEnabled || cost <= 0.0) {
            return true;
        }
        return true;
    }

    private void startTimeout(TPARequest request) {
        int timeoutTicks = this.config.timeout * 20;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.storage.removeRequest(request.senderId, request.targetId).thenRun(() -> {
            Component msg;
            Player sender = Bukkit.getPlayer((UUID)request.senderId);
            Player target = Bukkit.getPlayer((UUID)request.targetId);
            if (sender != null) {
                msg = this.langManager.getMessageFor(sender, "commands.tpa.request-expired", "<red>Your TPA request to {player} expired.", LanguageManager.ComponentPlaceholder.of("{player}", target != null ? target.getName() : "Unknown"));
                sender.sendMessage(msg);
            }
            if (target != null) {
                msg = this.langManager.getMessageFor(target, "commands.tpa.request-expired-target", "<red>TPA request from {player} expired.", LanguageManager.ComponentPlaceholder.of("{player}", sender != null ? sender.getName() : "Unknown"));
                target.sendMessage(msg);
            }
        }), (long)timeoutTicks);
    }

    private TPARequest findRequestByName(List<TPARequest> requests, String senderName) {
        return requests.stream().filter(req -> {
            String name = Bukkit.getOfflinePlayer((UUID)req.senderId).getName();
            return name != null && name.equalsIgnoreCase(senderName);
        }).findFirst().orElse(null);
    }

    private void acceptRequest(TPARequest request) {
        Player sender = Bukkit.getPlayer((UUID)request.senderId);
        Player target = Bukkit.getPlayer((UUID)request.targetId);
        if (sender == null || target == null) {
            return;
        }
        Component senderMsg = this.langManager.getMessageFor(sender, "commands.tpa.request-accepted", "<green>{player} accepted your TPA request. Teleporting in {delay}s...", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()), LanguageManager.ComponentPlaceholder.of("{delay}", String.valueOf(this.config.teleportDelay)));
        sender.sendMessage(senderMsg);
        Component targetMsg = this.langManager.getMessageFor(target, "commands.tpa.request-accepted-target", "<green>You accepted {player}'s TPA request.", LanguageManager.ComponentPlaceholder.of("{player}", sender.getName()));
        target.sendMessage(targetMsg);
        int warmupTicks = this.config.warmup * 20;
        int delayTicks = this.config.teleportDelay * 20;
        int totalDelay = warmupTicks + delayTicks;
        if (warmupTicks > 0) {
            sender.sendMessage(this.langManager.getMessageFor(sender, "commands.tpa.warmup-start", "<yellow>Warmup started... Don't move!", new LanguageManager.ComponentPlaceholder[0]));
            this.listener.registerWarmupTask(sender.getUniqueId(), Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {}, (long)warmupTicks).getTaskId());
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            try {
                Location loc = request.here ? sender.getLocation() : target.getLocation();
                Player toTeleport = request.here ? target : sender;
                toTeleport.teleport(loc);
                if (this.config.particlesEnabled) {
                    try {
                        Particle particle = Particle.valueOf((String)this.config.particleType);
                        loc.getWorld().spawnParticle(particle, loc, 50, 1.0, 1.0, 1.0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.playSound(sender, this.config.soundTeleport);
                this.playSound(target, this.config.soundTeleport);
                this.listener.unregisterWarmupTask(sender.getUniqueId());
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to teleport during TPA: " + ex.getMessage());
            }
        }, (long)totalDelay);
    }

    private void denyRequest(TPARequest request) {
        Component msg;
        Player sender = Bukkit.getPlayer((UUID)request.senderId);
        Player target = Bukkit.getPlayer((UUID)request.targetId);
        if (sender != null) {
            msg = this.langManager.getMessageFor(sender, "commands.tpa.request-denied", "<red>{player} denied your TPA request.", LanguageManager.ComponentPlaceholder.of("{player}", target != null ? target.getName() : "Unknown"));
            sender.sendMessage(msg);
            this.playSound(sender, this.config.soundDeny);
        }
        if (target != null) {
            msg = this.langManager.getMessageFor(target, "commands.tpa.request-denied-target", "<green>You denied {player}'s TPA request.", LanguageManager.ComponentPlaceholder.of("{player}", sender != null ? sender.getName() : "Unknown"));
            target.sendMessage(msg);
            this.playSound(target, this.config.soundDeny);
        }
        if (!this.config.economyEnabled || request.cost > 0.0) {
            // empty if block
        }
    }

    private void playSound(Player player, String soundName) {
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

