/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.SwapConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class SwapCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.swap";
    private final PlayerLanguageManager langManager;
    private final SwapConfig config;
    private final CommandDataStorage dataStorage;

    public SwapCommand(PlayerLanguageManager langManager, SwapConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getMessageFor(null, "commands.swap.only-player", "<red>Only players can use this command!</red>", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(player, "commands.swap.no-permission", "<red>You need permission <yellow>{permission}</yellow>!</red>", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            player.sendMessage(message);
            return true;
        }
        if (args.length != 1) {
            Component message = this.langManager.getMessageFor(player, "commands.swap.usage", "<red>Usage: <white>/swap <player></white></red>", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(message);
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || target.equals((Object)player)) {
            Component message = this.langManager.getMessageFor(player, "commands.swap.target-not-found", "<red>Player <white>{target}</white> not found or cannot swap with yourself.</red>", LanguageManager.ComponentPlaceholder.of("{target}", args[0]));
            player.sendMessage(message);
            return true;
        }
        Location loc1 = player.getLocation();
        Location loc2 = target.getLocation();
        player.teleport(loc2);
        target.teleport(loc1);
        Component swappedMsgPlayer = this.langManager.getMessageFor(player, "commands.swap.success", "<green>You swapped locations with <white>{target}</white>!</green>", LanguageManager.ComponentPlaceholder.of("{target}", target.getName()));
        player.sendMessage(swappedMsgPlayer);
        Component swappedMsgTarget = this.langManager.getMessageFor(target, "commands.swap.target-notified", "<green><white>{player}</white> swapped locations with you!</green>", LanguageManager.ComponentPlaceholder.of("{player}", player.getName()));
        target.sendMessage(swappedMsgTarget);
        this.trackUsage(player.getUniqueId(), "swap", 1);
        return true;
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "swap", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "swap", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "swap", "last_type", type);
            this.dataStorage.setState(playerId, "swap", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

