/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import net.godlycow.org.commands.config.StaffListConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class StaffListCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.stafflist";
    private final PlayerLanguageManager langManager;
    private final StaffListConfig config;

    public StaffListCommand(PlayerLanguageManager langManager, StaffListConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player playerSender;
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.stafflist.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        ArrayList<String> staffOnline = new ArrayList<String>();
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            if (!player2.hasPermission("serveressentials.stafflist")) continue;
            staffOnline.add(player2.getName());
        }
        sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.stafflist.header", "<#00ffff>--- Online Staff ---", new LanguageManager.ComponentPlaceholder[0]));
        if (staffOnline.isEmpty()) {
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.stafflist.none", "<#aaaaaa>No staff members online.", new LanguageManager.ComponentPlaceholder[0]));
        } else {
            for (String name : staffOnline) {
                Component line = this.langManager.getMessageFor(playerSender, "commands.stafflist.format", "<#00ff00>\u2022 <#ffff00>{player}", LanguageManager.ComponentPlaceholder.of("{player}", name));
                sender.sendMessage(line);
            }
        }
        return true;
    }
}

