/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.godlycow.org.commands.config.SpawnerConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public final class SpawnerCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.spawner";
    private static final String PERMISSION_ALL_MOBS = "essc.command.spawner.*";
    private final PlayerLanguageManager langManager;
    private final SpawnerConfig config;

    public SpawnerCommand(PlayerLanguageManager langManager, SpawnerConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        BlockState blockState;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.spawner.only-player", "<#B22222>\u274c Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.no-permission", "<#B22222>\u274c You don't have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        if (args.length > 1 || args[0].equalsIgnoreCase("help")) {
            this.sendHelpMessage(player);
            return true;
        }
        if (player.getTargetBlockExact(5) == null || !((blockState = player.getTargetBlockExact(5).getState()) instanceof CreatureSpawner)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.look-at-spawner", "<#B22222>\u274c Look at a spawner to change it!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        CreatureSpawner spawner = (CreatureSpawner)blockState;
        String mobName = args[0].toUpperCase(Locale.ROOT);
        try {
            EntityType type = EntityType.valueOf((String)mobName);
            String mobNameLower = mobName.toLowerCase(Locale.ROOT);
            String mobPermission = "essc.command.spawner." + mobNameLower;
            if (!player.hasPermission(PERMISSION_ALL_MOBS) && !player.hasPermission(mobPermission)) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.no-permission-mob", "<#B22222>\u274c You don't have permission to set a spawner to {mob}!", LanguageManager.ComponentPlaceholder.of("{mob}", mobNameLower)));
                return true;
            }
            spawner.setSpawnedType(type);
            spawner.update();
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.changed", "<#50DB00>\u2714 Spawner type changed to {mob}", LanguageManager.ComponentPlaceholder.of("{mob}", mobNameLower)));
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.spawner.invalid-mob", "<#B22222>\u274c Invalid mob type: {mob}", LanguageManager.ComponentPlaceholder.of("{mob}", args[0])));
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        Component help = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(this.langManager.getMessageFor(player, "commands.spawner.help.header", "<#FFD900><bold>=== Spawner Command Help ===</bold></#FFD900>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.spawner.help.description", "<#FFD900>Description: <white>Change the type of a creature spawner.</white>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.spawner.help.usage", "<#FFD900>Usage:</#FFD900> <white>/spawner <mob></white>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.spawner.help.permission", "<#FFD900>Required Permission:</#FFD900> <white>{permission}</white>", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)))).append(Component.newline())).append(this.langManager.getMessageFor(player, "commands.spawner.help.available.header", "<#FFD900>Available Mob Types:</#FFD900>", new LanguageManager.ComponentPlaceholder[0]))).append(Component.newline());
        List<String> availableMobs = this.getAvailableMobs(player);
        int mobsToShow = Math.min(5, availableMobs.size());
        for (int i = 0; i < mobsToShow; ++i) {
            String mob = availableMobs.get(i);
            help = help.append(this.langManager.getMessageFor(player, "commands.spawner.help.available.mob", "  <white>\u2022 {mob}</white>", LanguageManager.ComponentPlaceholder.of("{mob}", mob))).append(Component.newline());
        }
        if (availableMobs.size() > 5) {
            help = help.append(this.langManager.getMessageFor(player, "commands.spawner.help.available.more", "  <gray>... and {count} more</gray>", LanguageManager.ComponentPlaceholder.of("{count}", availableMobs.size() - 5))).append(Component.newline());
        }
        help = help.append(this.langManager.getMessageFor(player, "commands.spawner.help.footer", "<gray>Use <white>/spawner help</white> to see this message again.</gray>", new LanguageManager.ComponentPlaceholder[0]));
        player.sendMessage(help);
    }

    private List<String> getAvailableMobs(Player player) {
        ArrayList<String> mobs = new ArrayList<String>();
        for (EntityType type : EntityType.values()) {
            if (!type.isAlive()) continue;
            String mobName = type.name().toLowerCase(Locale.ROOT);
            String mobPermission = "essc.command.spawner." + mobName;
            if (!player.hasPermission(PERMISSION_ALL_MOBS) && !player.hasPermission(mobPermission)) continue;
            mobs.add(mobName);
        }
        return mobs;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player player;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!(sender instanceof Player) || !(player = (Player)sender).hasPermission(PERMISSION)) {
            return suggestions;
        }
        if (args.length == 1) {
            String partial = args[0].toLowerCase(Locale.ROOT);
            if ("help".startsWith(partial)) {
                suggestions.add("help");
            }
            for (EntityType type : EntityType.values()) {
                if (!type.isAlive()) continue;
                String mobName = type.name().toLowerCase(Locale.ROOT);
                String mobPermission = "essc.command.spawner." + mobName;
                if (!player.hasPermission(PERMISSION_ALL_MOBS) && !player.hasPermission(mobPermission) || !mobName.startsWith(partial)) continue;
                suggestions.add(mobName);
            }
        }
        return suggestions;
    }
}

