/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.SmithingTableConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SmithingTableCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.smithingtable";
    private final PlayerLanguageManager langManager;
    private final SmithingTableConfig config;

    public SmithingTableCommand(PlayerLanguageManager langManager, SmithingTableConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.smithingtable.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.smithingtable.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        player.openSmithingTable(null, true);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.smithingtable.success", "<green>Opened smithing table.", new LanguageManager.ComponentPlaceholder[0]));
        return true;
    }
}

