/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import com.serveressentials.api.shop.ShopAPI;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.godlycow.org.commands.config.ShopConfig;
import net.godlycow.org.database.DatabaseManager;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.economy.shop.ShopDataManager;
import net.godlycow.org.economy.shop.config.MainShopConfig;
import net.godlycow.org.economy.shop.config.loader.ShopConfigLoader;
import net.godlycow.org.economy.shop.gui.ShopGUIManager;
import net.godlycow.org.economy.shop.storage.ShopStorage;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ShopCommand
implements CommandExecutor {
    private static final String PERMISSION_USE = "essc.command.shop";
    private static final String PERMISSION_RELOAD = "essc.command.shop.reload";
    private static final String COMMAND_NAME = "shop";
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final ShopStorage storage;
    private final ShopConfig config;
    private final ShopGUIManager guiManager;
    private final ShopDataManager dataManager;
    private final EconomyManager economyManager;
    private final ShopAPI shopAPI;

    public ShopCommand(Plugin plugin, PlayerLanguageManager langManager, DatabaseManager dbManager, ShopConfig config, EconomyManager economyManager, ShopAPI shopAPI, ShopGUIManager guiManager, ShopDataManager dataManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.economyManager = economyManager;
        this.shopAPI = shopAPI;
        this.guiManager = guiManager;
        this.dataManager = dataManager;
        this.storage = new ShopStorage(plugin, dbManager);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.shop.only-player", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.shop.disabled", "<red>\u2717 The shop system is currently disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!player.hasPermission(PERMISSION_USE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.shop.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_USE)));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.no-economy", "<red>\u2717 Economy system is not available. Shop features disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("reload")) {
            return this.handleReload(player, args);
        }
        this.guiManager.openMainGUI(player);
        return true;
    }

    private boolean handleReload(Player player, String[] args) {
        if (!player.hasPermission(PERMISSION_RELOAD)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.shop.no-permission-reload", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_RELOAD)));
            return true;
        }
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.reload-error", "<red>\u2717 Cannot reload: Shop system is disabled!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.reload-error", "<red>\u2717 Cannot reload: Economy system is not available!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length >= 2 && args[1].equalsIgnoreCase("tofile")) {
            return this.handleSaveToFile(player);
        }
        this.reloadShop(player).thenAccept(success -> {
            if (success.booleanValue()) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.reload-success", "<green>\u2713 Shop reloaded from YML files and saved to database.", new LanguageManager.ComponentPlaceholder[0]));
            } else {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.reload-error", "<red>\u2717 Error reloading shop configuration.", new LanguageManager.ComponentPlaceholder[0]));
            }
        });
        return true;
    }

    private boolean handleSaveToFile(Player player) {
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.save-to-file-error", "<red>\u2717 Cannot save: Shop system is disabled!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                File mainFile = new File(this.config.getShopFolder(), "main.yml");
                MainShopConfig mainConfig = this.guiManager.getMainConfig();
                if (mainConfig != null) {
                    ShopConfigLoader.saveMainConfig(mainFile, mainConfig);
                }
                this.guiManager.getSectionCache().forEach((sectionName, sectionConfig) -> {
                    File sectionFile = new File(this.config.getShopFolder(), sectionName + ".yml");
                    ShopConfigLoader.saveSectionConfig(sectionFile, sectionConfig);
                });
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.save-to-file-success", "<green>\u2713 Saved current database config to YML files!", new LanguageManager.ComponentPlaceholder[0]));
                future.complete(true);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to save to file: " + e.getMessage());
                e.printStackTrace();
                player.sendMessage(this.langManager.getMessageFor(player, "commands.economy.shop.save-to-file-error", "<red>\u2717 Failed to save to files!", new LanguageManager.ComponentPlaceholder[0]));
                future.complete(false);
            }
        });
        return true;
    }

    private CompletableFuture<Boolean> reloadShop(Player player) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Bukkit.getScheduler().callSyncMethod(this.plugin, () -> {
                    this.guiManager.reloadConfigs(true);
                    this.guiManager.refreshOpenInventories();
                    return null;
                }).get();
                return true;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to reload shop: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }, CompletableFuture.delayedExecutor(0L, TimeUnit.MILLISECONDS, runnable -> Bukkit.getScheduler().runTaskAsynchronously(this.plugin, runnable)));
    }

    public ShopDataManager getDataManager() {
        return this.dataManager;
    }

    public ShopAPI getShopAPI() {
        return this.shopAPI;
    }

    public ShopGUIManager getGuiManager() {
        return this.guiManager;
    }
}

