/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.settings.SettingsConfig;
import net.godlycow.org.settings.SettingsGUI;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class SettingsCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.settings";
    private final PlayerLanguageManager langManager;
    private final SettingsConfig config;
    private final SettingsGUI gui;

    public SettingsCommand(PlayerLanguageManager langManager, SettingsConfig config, SettingsGUI gui) {
        this.langManager = langManager;
        this.config = config;
        this.gui = gui;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.settings.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.settings.no-permission", "<red>You don't have permission to use /settings!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        this.gui.open(player, 0);
        return true;
    }
}

