/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.Collections;
import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.SetLoreLineConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class SetLoreLineCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.setloreline";
    private final PlayerLanguageManager langManager;
    private final SetLoreLineConfig config;
    private final CommandDataStorage dataStorage;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public SetLoreLineCommand(PlayerLanguageManager langManager, SetLoreLineConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.setloreline.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.setloreline.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.setloreline.usage", "<red>Usage: <white>/setloreline <text>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.setloreline.no-item", "<red>You're not holding an item.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return true;
        }
        String input = String.join((CharSequence)" ", args);
        Object loreComponent = this.miniMessage.deserialize(input);
        meta.lore(Collections.singletonList(loreComponent));
        item.setItemMeta(meta);
        player.sendMessage(this.langManager.getMessageFor(player, "commands.setloreline.lore-set", "<green>Lore set to: <white>{lore}", LanguageManager.ComponentPlaceholder.of("{lore}", input)));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "setloreline", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "setloreline", "usage_count", String.valueOf(count + 1));
        });
        return true;
    }
}

