/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.List;
import net.godlycow.org.commands.config.ServerInfoConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ServerInfoCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.serverinfo";
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final ServerInfoConfig config;
    private final DecimalFormat df = new DecimalFormat("#.##");

    public ServerInfoCommand(Plugin plugin, PlayerLanguageManager langManager, ServerInfoConfig config) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.serverinfo.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        long maxMemory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long totalMemory = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
        long usedMemory = totalMemory - freeMemory;
        File root = new File(".");
        long freeDiskMB = root.getFreeSpace() / 1024L / 1024L;
        long totalDiskMB = root.getTotalSpace() / 1024L / 1024L;
        double tps = Bukkit.getTPS()[0];
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        int cpuCores = osBean.getAvailableProcessors();
        Object cpuLoadStr = "N/A";
        try {
            OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
            double load = sunOsBean.getSystemCpuLoad();
            if (load >= 0.0) {
                cpuLoadStr = this.df.format(load * 100.0) + "%";
            }
        }
        catch (ClassCastException sunOsBean) {
            // empty catch block
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        long uptimeMillis = runtimeMXBean.getUptime();
        long uptimeSeconds = uptimeMillis / 1000L;
        long uptimeMinutes = uptimeSeconds / 60L;
        long uptimeHours = uptimeMinutes / 60L;
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        String hostname = "Unknown";
        String hostAddress = "Unknown";
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
            hostAddress = localHost.getHostAddress();
        }
        catch (UnknownHostException localHost) {
            // empty catch block
        }
        StringBuilder netInterfaces = new StringBuilder();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface netIf = nets.nextElement();
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                Enumeration<InetAddress> addresses = netIf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    netInterfaces.append(netIf.getDisplayName()).append(": ").append(addr.getHostAddress()).append(", ");
                }
            }
        }
        catch (SocketException nets) {
            // empty catch block
        }
        String netInterfacesStr = netInterfaces.length() > 0 ? netInterfaces.substring(0, netInterfaces.length() - 2) : "None";
        int pluginCount = Bukkit.getPluginManager().getPlugins().length;
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        int maxPlayers = Bukkit.getMaxPlayers();
        String minecraftVersion = Bukkit.getVersion();
        String paperVersion = Bukkit.getName() + " " + Bukkit.getBukkitVersion();
        String gpuInfo = "Not Available";
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.header", "<gold>========== Server Information ==========", new LanguageManager.ComponentPlaceholder[0]));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.ram", "<green>RAM: <white>{used}MB / {max}MB", LanguageManager.ComponentPlaceholder.of("{used}", String.valueOf(usedMemory)), LanguageManager.ComponentPlaceholder.of("{max}", String.valueOf(maxMemory))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.disk", "<green>Disk: <white>{free}MB free / {total}MB total", LanguageManager.ComponentPlaceholder.of("{free}", String.valueOf(freeDiskMB)), LanguageManager.ComponentPlaceholder.of("{total}", String.valueOf(totalDiskMB))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.tps", "<green>TPS: <white>{tps}", LanguageManager.ComponentPlaceholder.of("{tps}", this.df.format(tps))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.cpu", "<green>CPU: <white>{cores} cores, {load} load", LanguageManager.ComponentPlaceholder.of("{cores}", String.valueOf(cpuCores)), LanguageManager.ComponentPlaceholder.of("{load}", cpuLoadStr)));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.os", "<green>OS: <white>{name} {version} ({arch})", LanguageManager.ComponentPlaceholder.of("{name}", osName), LanguageManager.ComponentPlaceholder.of("{version}", osVersion), LanguageManager.ComponentPlaceholder.of("{arch}", osArch)));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.uptime", "<green>Uptime: <white>{hours}h {minutes}m {seconds}s", LanguageManager.ComponentPlaceholder.of("{hours}", String.valueOf(uptimeHours)), LanguageManager.ComponentPlaceholder.of("{minutes}", String.valueOf(uptimeMinutes % 60L)), LanguageManager.ComponentPlaceholder.of("{seconds}", String.valueOf(uptimeSeconds % 60L))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.java", "<green>Java: <white>{version}", LanguageManager.ComponentPlaceholder.of("{version}", System.getProperty("java.version"))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.host", "<green>Host: <white>{hostname} ({address})", LanguageManager.ComponentPlaceholder.of("{hostname}", hostname), LanguageManager.ComponentPlaceholder.of("{address}", hostAddress)));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.net", "<green>Network: <white>{interfaces}", LanguageManager.ComponentPlaceholder.of("{interfaces}", netInterfacesStr)));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.plugins", "<green>Plugins: <white>{count}", LanguageManager.ComponentPlaceholder.of("{count}", String.valueOf(pluginCount))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.minecraft", "<green>Minecraft: <white>{version}", LanguageManager.ComponentPlaceholder.of("{version}", minecraftVersion)));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.paper", "<green>Server: <white>{version}", LanguageManager.ComponentPlaceholder.of("{version}", paperVersion)));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.players", "<green>Players: <white>{online}/{max}", LanguageManager.ComponentPlaceholder.of("{online}", String.valueOf(onlinePlayers)), LanguageManager.ComponentPlaceholder.of("{max}", String.valueOf(maxPlayers))));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.gpu", "<green>GPU: <white>{gpu}", LanguageManager.ComponentPlaceholder.of("{gpu}", gpuInfo)));
        player.sendMessage(this.langManager.getMessageFor(player, "commands.serverinfo.jvm", "<green>JVM Args: <white>{args}", LanguageManager.ComponentPlaceholder.of("{args}", String.join((CharSequence)", ", jvmArgs))));
        return true;
    }
}

