/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.SellConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.sellgui.gui.SellGUIManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class SellCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.sell";
    private static final String COMMAND_NAME = "sell";
    private final PlayerLanguageManager langManager;
    private final SellConfig config;
    private final SellGUIManager guiManager;
    private final EconomyManager economyManager;
    private final JavaPlugin plugin;

    public SellCommand(JavaPlugin plugin, PlayerLanguageManager langManager, SellConfig config, SellGUIManager guiManager, EconomyManager economyManager) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.config = config;
        this.guiManager = guiManager;
        this.economyManager = economyManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            String message = this.langManager.getMessageFor(null, "commands.sell.only-player", "<red>This command can only be used by players!", new LanguageManager.ComponentPlaceholder[0]).toString();
            sender.sendMessage(message);
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.sell.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (!this.config.enabled) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.disabled", "<red>The sell GUI is currently disabled.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (!this.economyManager.isEnabled()) {
            player.sendMessage(this.langManager.getMessageFor(player, "economy.sellgui.no-economy", "<red>\u2717 Economy system is not available. Please contact an administrator.", new LanguageManager.ComponentPlaceholder[0]));
            this.plugin.getLogger().warning("Sell command attempted but economy system is disabled!");
            return true;
        }
        this.guiManager.openSellGUI(player);
        return true;
    }
}

