/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.concurrent.ConcurrentHashMap;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.rtp.RtpConfig;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RtpCommand
implements CommandExecutor {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final RtpConfig rtpConfig;
    private final ConcurrentHashMap<String, World> worldCache = new ConcurrentHashMap();

    public RtpCommand(Plugin plugin, PlayerLanguageManager langManager, RtpConfig rtpConfig) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.rtpConfig = rtpConfig;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only_player", "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("essc.command.rtp")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no_permission", "You don't have permission!", LanguageManager.ComponentPlaceholder.of("{permission}", "rtp.use")));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("essc.command.rtp.reload")) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.no_permission", "You don't have permission!", LanguageManager.ComponentPlaceholder.of("{permission}", "rtp.reload")));
                return true;
            }
            this.rtpConfig.reload();
            this.worldCache.clear();
            player.sendMessage(this.langManager.getMessageFor(player, "commands.rtp.reloaded", "RTP configuration reloaded!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        this.openRtpGui(player);
        return true;
    }

    private void openRtpGui(Player player) {
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Component title = this.langManager.getMessageFor(player, "commands.rtp.gui.title", "<green>RTP Menu", new LanguageManager.ComponentPlaceholder[0]);
            Inventory gui = Bukkit.createInventory(null, (int)9, (Component)title);
            gui.setItem(2, this.createGuiItem(player, Material.GRASS_BLOCK, "overworld"));
            gui.setItem(4, this.createGuiItem(player, Material.NETHERRACK, "nether"));
            gui.setItem(6, this.createGuiItem(player, Material.END_STONE, "end"));
            player.openInventory(gui);
        });
    }

    private ItemStack createGuiItem(Player player, Material material, String worldKey) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.langManager.getMessageFor(player, "commands.rtp.gui." + worldKey + ".name", worldKey, new LanguageManager.ComponentPlaceholder[0]));
        meta.lore(this.langManager.getMessageList(player, "rtp.gui." + worldKey + ".lore"));
        item.setItemMeta(meta);
        return item;
    }

    private World getWorld(String name) {
        return this.worldCache.computeIfAbsent(name, Bukkit::getWorld);
    }
}

