/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.godlycow.org.reports.ReportConfig;
import net.godlycow.org.reports.model.Report;
import net.godlycow.org.reports.storage.ReportStorage;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ReportCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final PlayerLanguageManager langManager;
    private final ReportStorage storage;
    private final ReportConfig config;

    public ReportCommand(JavaPlugin plugin, PlayerLanguageManager langManager, ReportStorage storage, ReportConfig config) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.storage = storage;
        this.config = config;
    }

    private Player getPlayerOrNull(CommandSender sender) {
        return sender instanceof Player ? (Player)sender : null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        switch (cmd = command.getName().toLowerCase()) {
            case "report": {
                return this.handleReport(sender, args);
            }
            case "reportclear": {
                return this.handleClear(sender, args);
            }
        }
        return false;
    }

    private boolean handleReport(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.langManager.getMessageFor(null, "commands.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(msg.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("essc.command.report")) {
            Component msg = this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.report"));
            player.sendMessage(msg);
            return true;
        }
        if (args.length < 2) {
            Component msg = this.langManager.getMessageFor(player, "commandsreports.command.usage", "<red>Usage: /report <player> <reason>", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(msg);
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayerIfCached((String)targetName);
        if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
            Component msg = this.langManager.getMessageFor(player, "commands.reports.command.invalid-player", "<red>Player <yellow>{player}</yellow> not found.", LanguageManager.ComponentPlaceholder.of("{player}", targetName));
            player.sendMessage(msg);
            return true;
        }
        this.storage.getCooldown(player.getUniqueId()).thenAccept(lastUsed -> {
            long now = System.currentTimeMillis();
            long cdMillis = (long)this.config.cooldown * 1000L;
            if (now - lastUsed < cdMillis) {
                long remainingSeconds = (cdMillis - (now - lastUsed)) / 1000L;
                Component msg = this.langManager.getMessageFor(player, "commands.reports.cooldown", "<red>Please wait <yellow>{time}</yellow> seconds before reporting again.", LanguageManager.ComponentPlaceholder.of("{time}", String.valueOf(remainingSeconds)));
                player.sendMessage(msg);
                return;
            }
            StringBuilder reasonBuilder = new StringBuilder();
            for (int i = 1; i < args.length; ++i) {
                if (i > 1) {
                    reasonBuilder.append(" ");
                }
                reasonBuilder.append(args[i]);
            }
            String reason = reasonBuilder.toString();
            if (reason.length() > this.config.maxReasonLength) {
                Component msg = this.langManager.getMessageFor(player, "commands.reports.reason-too-long", "<red>Reason too long! Max <yellow>{max}</yellow> characters.", LanguageManager.ComponentPlaceholder.of("{max}", String.valueOf(this.config.maxReasonLength)));
                player.sendMessage(msg);
                return;
            }
            String reportId = UUID.randomUUID().toString().substring(0, 8);
            Report report = new Report(reportId, player.getUniqueId(), target.getUniqueId(), reason, System.currentTimeMillis(), true);
            ((CompletableFuture)this.storage.addReport(report).thenRun(() -> {
                this.storage.saveCooldown(player.getUniqueId(), System.currentTimeMillis());
                Component msg = this.langManager.getMessageFor(player, "commands.reports.command.submitted", "<green>Report submitted against <yellow>{player}</yellow>.", LanguageManager.ComponentPlaceholder.of("{player}", target.getName()));
                player.sendMessage(msg);
                this.notifyStaff(report, target.getName());
            })).exceptionally(ex -> {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.reports.error", "<red>Error submitting report. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
                this.plugin.getLogger().warning("Failed to submit report: " + ex.getMessage());
                return null;
            });
        });
        return true;
    }

    private void notifyStaff(Report report, String targetName) {
        Component notifyMsg = this.langManager.getMessageFor(null, "commands.reports.command.notify", "<red>[REPORT]</red> <yellow>{reporter}</yellow> reported <gold>{target}</gold> for <gray>{reason}</gray> <dark_gray>(ID: {id})</dark_gray>", LanguageManager.ComponentPlaceholder.of("{id}", report.id()), LanguageManager.ComponentPlaceholder.of("{reporter}", Bukkit.getOfflinePlayer((UUID)report.reporterId()).getName()), LanguageManager.ComponentPlaceholder.of("{target}", targetName != null ? targetName : "Unknown"), LanguageManager.ComponentPlaceholder.of("{reason}", report.reason()));
        boolean notified = false;
        for (Player admin : Bukkit.getOnlinePlayers()) {
            if (!admin.hasPermission("essc.command.report.*")) continue;
            admin.sendMessage(notifyMsg);
            notified = true;
        }
        if (!notified && !this.config.notifyOnlineOnly) {
            this.storage.markAsCleared(report.id());
        }
    }

    private boolean handleClear(CommandSender sender, String[] args) {
        if (!sender.hasPermission("essc.command.report.*")) {
            Player player = this.getPlayerOrNull(sender);
            Component msg = this.langManager.getMessageFor(player, "commands.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", "essc.command.report.*"));
            if (player != null) {
                player.sendMessage(msg);
            } else {
                sender.sendMessage(msg.toString());
            }
            return true;
        }
        if (args.length < 1) {
            Player player = this.getPlayerOrNull(sender);
            Component msg = this.langManager.getMessageFor(player, "commands.reports.commandclear.usage", "<red>Usage: /reportclear <id>", new LanguageManager.ComponentPlaceholder[0]);
            if (player != null) {
                player.sendMessage(msg);
            } else {
                sender.sendMessage(msg.toString());
            }
            return true;
        }
        String id = args[0];
        this.storage.getReport(id).thenAccept(optReport -> {
            if (optReport.isEmpty()) {
                Player player = this.getPlayerOrNull(sender);
                Component msg = this.langManager.getMessageFor(player, "commands.reports.commandclear.invalid", "<red>Invalid report ID: <yellow>{id}</yellow>", LanguageManager.ComponentPlaceholder.of("{id}", id));
                if (player != null) {
                    player.sendMessage(msg);
                } else {
                    sender.sendMessage(msg.toString());
                }
                return;
            }
            ((CompletableFuture)this.storage.clearReport(id).thenRun(() -> {
                Player player = this.getPlayerOrNull(sender);
                Component msg = this.langManager.getMessageFor(player, "commands.reports.commandclear.cleared", "<green>Cleared report ID: <yellow>{id}</yellow>", LanguageManager.ComponentPlaceholder.of("{id}", id));
                if (player != null) {
                    player.sendMessage(msg);
                } else {
                    sender.sendMessage(msg.toString());
                }
            })).exceptionally(ex -> {
                Component msg;
                Player player = this.getPlayerOrNull(sender);
                Component component = msg = player != null ? this.langManager.getMessageFor(player, "commands.reports.error", "<red>Error clearing report. Please try again.", new LanguageManager.ComponentPlaceholder[0]) : this.langManager.getMessageFor(null, "commands.reports.error", "<red>Error clearing report. Please try again.", new LanguageManager.ComponentPlaceholder[0]);
                if (player != null) {
                    player.sendMessage(msg);
                } else {
                    sender.sendMessage(msg.toString());
                }
                this.plugin.getLogger().warning("Failed to clear report: " + ex.getMessage());
                return null;
            });
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String cmd = command.getName().toLowerCase();
        if (cmd.equals("report") && args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).toList();
        }
        if (cmd.equals("reportclear") && args.length == 1) {
            return List.of();
        }
        return List.of();
    }

    public void handleJoin(Player player) {
        if (!player.hasPermission("essc.command.report.*")) {
            return;
        }
        this.storage.getPendingReports().thenAccept(reports -> {
            if (reports.isEmpty()) {
                return;
            }
            Component header = this.langManager.getMessageFor(player, "commands.reports.reportslist.header", "<gold>You have pending reports to review:", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(header);
            for (Report report2 : reports) {
                String reporterName = Bukkit.getOfflinePlayer((UUID)report2.reporterId()).getName();
                String targetName = Bukkit.getOfflinePlayer((UUID)report2.targetId()).getName();
                Component entry = this.langManager.getMessageFor(player, "commands.reports.reportslist.entry", "<red>[PENDING]</red> <yellow>{reporter}</yellow> \u2192 <gold>{target}</gold>: <gray>{reason}</gray> <dark_gray>(ID: {id})</dark_gray>", LanguageManager.ComponentPlaceholder.of("{id}", report2.id()), LanguageManager.ComponentPlaceholder.of("{reporter}", reporterName != null ? reporterName : "Unknown"), LanguageManager.ComponentPlaceholder.of("{target}", targetName != null ? targetName : "Unknown"), LanguageManager.ComponentPlaceholder.of("{reason}", report2.reason()));
                player.sendMessage(entry);
            }
            reports.forEach(report -> this.storage.markAsCleared(report.id()));
        });
    }
}

