/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.RecipeConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public final class RecipeCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "essc.command.recipe";
    private final PlayerLanguageManager langManager;
    private final RecipeConfig config;
    private final CommandDataStorage dataStorage;

    public RecipeCommand(PlayerLanguageManager langManager, RecipeConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.recipe.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.usage", "<red>Usage: <white>/recipe <recipe>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        NamespacedKey key = NamespacedKey.fromString((String)args[0].toLowerCase());
        if (key == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.not-found", "<red>Recipe not found!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Recipe recipe = Bukkit.getRecipe((NamespacedKey)key);
        if (recipe == null) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.not-found", "<red>Recipe not found!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        ItemStack result = recipe.getResult();
        player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.result", "<green>Recipe for: <yellow>{item}", LanguageManager.ComponentPlaceholder.of("{item}", result.getType().toString())));
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.shaped-header", "<aqua>Shaped Recipe Ingredients:", new LanguageManager.ComponentPlaceholder[0]));
            shaped.getIngredientMap().forEach((character, itemStack) -> {
                if (itemStack != null && itemStack.getType() != Material.AIR) {
                    player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.ingredient-line", "<yellow>- {char}: {item} x{amount}", LanguageManager.ComponentPlaceholder.of("{char}", character.toString()), LanguageManager.ComponentPlaceholder.of("{item}", itemStack.getType().toString()), LanguageManager.ComponentPlaceholder.of("{amount}", String.valueOf(itemStack.getAmount()))));
                }
            });
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.shapeless-header", "<aqua>Shapeless Recipe Ingredients:", new LanguageManager.ComponentPlaceholder[0]));
            for (ItemStack ingredient : shapeless.getIngredientList()) {
                if (ingredient == null || ingredient.getType() == Material.AIR) continue;
                player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.ingredient-line-shapeless", "<yellow>- {item} x{amount}", LanguageManager.ComponentPlaceholder.of("{item}", ingredient.getType().toString()), LanguageManager.ComponentPlaceholder.of("{amount}", String.valueOf(ingredient.getAmount()))));
            }
        } else {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.recipe.unknown-type", "<red>Unknown recipe type!", new LanguageManager.ComponentPlaceholder[0]));
        }
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "recipe", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "recipe", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "recipe", "last_recipe", recipe.getResult().getType().toString());
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            String current = args[0].toLowerCase();
            ArrayList<String> results = new ArrayList<String>();
            Bukkit.recipeIterator().forEachRemaining(recipe -> {
                if (recipe instanceof Keyed) {
                    NamespacedKey key;
                    String name;
                    Keyed keyed = (Keyed)recipe;
                    if (recipe.getResult() != null && (name = (key = keyed.getKey()).toString()).toLowerCase().startsWith(current)) {
                        results.add(name);
                    }
                }
            });
            return results;
        }
        return Collections.emptyList();
    }
}

