/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.PowerToolConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class PowerToolCommand
implements CommandExecutor,
Listener {
    private static final String PERMISSION = "essc.command.powertool";
    private static final String PERMISSION_CREATE = "essc.command.powertool.create";
    private final PlayerLanguageManager langManager;
    private final PowerToolConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;
    private final NamespacedKey commandKey;
    private final NamespacedKey usesKey;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public PowerToolCommand(PlayerLanguageManager langManager, PowerToolConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
        this.commandKey = new NamespacedKey(plugin, "powertool_command");
        this.usesKey = new NamespacedKey(plugin, "powertool_uses");
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int uses;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.powertool.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.powertool.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (!player.hasPermission(PERMISSION_CREATE)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.powertool.no-permission-create", "<red>You need permission <yellow>{permission}</yellow> to create PowerTools!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION_CREATE)));
            return true;
        }
        String fullInput = String.join((CharSequence)" ", args);
        String[] parts = fullInput.split("\\|");
        if (parts.length < 5) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.powertool.usage", "<red>Usage: <white>/powertool <command> | <uses> | <name> | <tool> | enchanted <yes/no>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        String boundCommand = parts[0].trim();
        try {
            uses = Integer.parseInt(parts[1].trim());
            if (uses < -1 || uses > this.config.maxUses()) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.powertool.invalid-uses", "<red>Uses must be -1 (infinite) or 1-{max}.", LanguageManager.ComponentPlaceholder.of("{max}", this.config.maxUses())));
            return true;
        }
        String displayName = parts[2].trim();
        String toolName = parts[3].trim().toUpperCase();
        Material toolMaterial = Material.matchMaterial((String)toolName);
        if (toolMaterial == null || !this.config.isAllowedMaterial(toolMaterial)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.powertool.invalid-tool", "<red>Invalid tool material: <white>{tool}", LanguageManager.ComponentPlaceholder.of("{tool}", toolName)));
            return true;
        }
        boolean enchanted = parts[4].trim().equalsIgnoreCase("enchanted yes");
        ItemStack tool = this.createPowerTool(toolMaterial, displayName, boundCommand, uses, enchanted);
        player.getInventory().addItem(new ItemStack[]{tool});
        player.sendMessage(this.langManager.getMessageFor(player, "commands.powertool.received-tool", "<green>\u2713 You received PowerTool: <white>{name}", LanguageManager.ComponentPlaceholder.of("{name}", displayName)));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "powertool", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "powertool", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "powertool", "last_command", boundCommand);
        });
        return true;
    }

    @EventHandler
    public void onPowerToolUse(PlayerInteractEvent event) {
        if (event.getItem() == null) {
            return;
        }
        ItemStack tool = event.getItem();
        ItemMeta meta = tool.getItemMeta();
        if (meta == null) {
            return;
        }
        String command = (String)meta.getPersistentDataContainer().get(this.commandKey, PersistentDataType.STRING);
        Integer uses = (Integer)meta.getPersistentDataContainer().get(this.usesKey, PersistentDataType.INTEGER);
        if (command == null || uses == null) {
            return;
        }
        Player player = event.getPlayer();
        player.performCommand(command);
        if (uses > 0) {
            uses = uses - 1;
            meta.getPersistentDataContainer().set(this.usesKey, PersistentDataType.INTEGER, (Object)uses);
            List lore = meta.lore();
            if (lore != null && lore.size() > 1) {
                lore.set(1, this.miniMessage.deserialize(uses == 0 ? "<gray>Uses: <white>0" : "<gray>Uses: <white>" + uses));
                meta.lore(lore);
            }
            tool.setItemMeta(meta);
            if (uses == 0) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.powertool.out-of-uses", "<red>\u26a0 Your PowerTool has run out of uses!", new LanguageManager.ComponentPlaceholder[0]));
                player.getInventory().removeItem(new ItemStack[]{tool});
            }
        }
    }

    private ItemStack createPowerTool(Material material, String displayName, String boundCommand, int uses, boolean enchanted) {
        ItemStack tool = new ItemStack(material, 1);
        ItemMeta meta = tool.getItemMeta();
        if (meta != null) {
            meta.displayName(this.miniMessage.deserialize(displayName));
            ArrayList lore = new ArrayList();
            lore.add(this.miniMessage.deserialize("<gray>Command: <yellow>/" + boundCommand));
            lore.add(this.miniMessage.deserialize(uses == -1 ? "<gray>Uses: <green>\u221e" : "<gray>Uses: <green>" + uses + "</green>"));
            lore.add(this.miniMessage.deserialize("<gray>(Right-click to use)"));
            meta.lore(lore);
            if (enchanted) {
                meta.addEnchant(Enchantment.MENDING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            meta.getPersistentDataContainer().set(this.commandKey, PersistentDataType.STRING, (Object)boundCommand);
            meta.getPersistentDataContainer().set(this.usesKey, PersistentDataType.INTEGER, (Object)uses);
            tool.setItemMeta(meta);
        }
        return tool;
    }

    public void unregister() {
        PlayerInteractEvent.getHandlerList().unregister((Listener)this);
    }
}

