/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import net.godlycow.org.commands.CommandDataStorage;
import net.godlycow.org.commands.config.PlaytimeConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PlaytimeCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.playtime";
    private final PlayerLanguageManager langManager;
    private final PlaytimeConfig config;
    private final CommandDataStorage dataStorage;

    public PlaytimeCommand(PlayerLanguageManager langManager, PlaytimeConfig config, CommandDataStorage dataStorage) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.playtime.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.playtime.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        if (args.length > 0) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.playtime.usage", "<red>Usage: <white>/playtime", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        long ticks = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
        long minutes = ticks / 1200L;
        long hours = minutes / 60L;
        long remainingMinutes = minutes % 60L;
        player.sendMessage(this.langManager.getMessageFor(player, "commands.playtime.playtime", "<green>Your playtime: <gold>{hours}h {minutes}m", LanguageManager.ComponentPlaceholder.of("{hours}", hours), LanguageManager.ComponentPlaceholder.of("{minutes}", remainingMinutes)));
        UUID playerId = player.getUniqueId();
        this.dataStorage.getState(playerId, "playtime", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "playtime", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "playtime", "last_checked", String.valueOf(System.currentTimeMillis()));
        });
        return true;
    }
}

