/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import net.godlycow.org.commands.config.PlayerInfoConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PlayerInfoCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.playerinfo";
    private final PlayerLanguageManager langManager;
    private final PlayerInfoConfig config;

    public PlayerInfoCommand(PlayerLanguageManager langManager, PlayerInfoConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.no-permission", "<red>You do not have permission to use this command!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.usage", "<red>Usage: /playerinfo <player>", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.not-found", "<red>Player not found.", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.header", "<gold>----- Player Info -----", new LanguageManager.ComponentPlaceholder[0]));
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.name", "<yellow>Name: <white>{player}", LanguageManager.ComponentPlaceholder.of("{player}", target.getName())));
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.uuid", "<yellow>UUID: <white>{uuid}", LanguageManager.ComponentPlaceholder.of("{uuid}", target.getUniqueId().toString())));
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.health", "<yellow>Health: <white>{health}/{maxhealth}", LanguageManager.ComponentPlaceholder.of("{health}", String.valueOf(target.getHealth())), LanguageManager.ComponentPlaceholder.of("{maxhealth}", String.valueOf(target.getMaxHealth()))));
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.food", "<yellow>Food: <white>{food}", LanguageManager.ComponentPlaceholder.of("{food}", String.valueOf(target.getFoodLevel()))));
        sender.sendMessage(this.langManager.getMessageFor(player, "commands.playerinfo.location", "<yellow>Location: <white>{location}", LanguageManager.ComponentPlaceholder.of("{location}", target.getLocation().toVector().toString())));
        return true;
    }
}

