/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.godlycow.org.commands.config.PingAllConfig;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PingAllCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.pingall";
    private final PlayerLanguageManager langManager;
    private final PingAllConfig config;

    public PingAllCommand(PlayerLanguageManager langManager, PingAllConfig config) {
        this.langManager = langManager;
        this.config = config;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player playerSender;
        Player player = playerSender = sender instanceof Player ? (Player)sender : null;
        if (!sender.hasPermission(PERMISSION)) {
            sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.pingall.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        sender.sendMessage(this.langManager.getMessageFor(playerSender, "commands.pingall.header", "<green>Online Player Pings:", new LanguageManager.ComponentPlaceholder[0]));
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            int ping = this.getPlayerPing(player2);
            Object pingDisplay = ping >= 0 ? ping + "ms" : "N/A";
            Component line = this.langManager.getMessageFor(playerSender, "commands.pingall.player-line", "<yellow>{player}: <aqua>{ping}", LanguageManager.ComponentPlaceholder.of("{player}", player2.getName()), LanguageManager.ComponentPlaceholder.of("{ping}", pingDisplay));
            sender.sendMessage(line);
        }
        return true;
    }

    private int getPlayerPing(Player player) {
        try {
            Method getPingMethod = Player.class.getMethod("getPing", new Class[0]);
            return (Integer)getPingMethod.invoke((Object)player, new Object[0]);
        }
        catch (NoSuchMethodException ignored) {
            try {
                String version = this.getServerVersion();
                Class<?> craftPlayerClass = Class.forName("org.bukkit.craftbukkit." + version + ".entity.CraftPlayer");
                Object craftPlayer = craftPlayerClass.cast(player);
                Method getHandle = craftPlayerClass.getMethod("getHandle", new Class[0]);
                Object entityPlayer = getHandle.invoke(craftPlayer, new Object[0]);
                Field pingField = entityPlayer.getClass().getField("ping");
                return pingField.getInt(entityPlayer);
            }
            catch (Exception e) {
                return -1;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String getServerVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

