/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.config.PayToggleConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PayToggleCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.paytoggle";
    private static final String COMMAND_NAME = "paytoggle";
    private final PlayerLanguageManager langManager;
    private final PayToggleConfig config;
    private final EconomyManager economyManager;

    public PayToggleCommand(PlayerLanguageManager langManager, PayToggleConfig config, EconomyManager economyManager) {
        this.langManager = langManager;
        this.config = config;
        this.economyManager = economyManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.paytoggle.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.paytoggle.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        UUID playerId = player.getUniqueId();
        String playerName = player.getName();
        ((CompletableFuture)this.economyManager.hasPaymentsDisabled(playerId.toString()).thenCompose(disabled -> {
            boolean newState = disabled == false;
            return this.economyManager.setPaymentsDisabled(playerId.toString(), playerName, newState).thenRun(() -> {
                String messageKey = newState ? "commands.paytoggle.disabled" : "commands.paytoggle.enabled";
                player.sendMessage(this.langManager.getMessageFor(player, messageKey, "<green>Payments have been <yellow>{state}</yellow>.", LanguageManager.ComponentPlaceholder.of("{state}", newState ? "disabled" : "enabled")));
            });
        })).exceptionally(ex -> {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.paytoggle.error", "<red>Error toggling payment state. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
            return null;
        });
        return true;
    }
}

