/*
 * Decompiled with CFR 0.152.
 */
package net.godlycow.org.commands.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.godlycow.org.commands.config.PayConfirmToggleConfig;
import net.godlycow.org.economy.eco.EconomyManager;
import net.godlycow.org.language.LanguageManager;
import net.godlycow.org.language.PlayerLanguageManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class PayConfirmToggleCommand
implements CommandExecutor {
    private static final String PERMISSION = "essc.command.payconfirmtoggle";
    private static final String COMMAND_NAME = "payconfirmtoggle";
    private final PlayerLanguageManager langManager;
    private final PayConfirmToggleConfig config;
    private final EconomyManager economyManager;

    public PayConfirmToggleCommand(PlayerLanguageManager langManager, PayConfirmToggleConfig config, EconomyManager economyManager) {
        this.langManager = langManager;
        this.config = config;
        this.economyManager = economyManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.payconfirmtoggle.only-player", "<red>Only players can use this command.", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.payconfirmtoggle.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION)));
            return true;
        }
        UUID playerId = player.getUniqueId();
        String playerName = player.getName();
        ((CompletableFuture)this.economyManager.hasPayConfirmDisabled(playerId.toString()).thenCompose(confirmDisabled -> {
            boolean newState = confirmDisabled == false;
            return this.economyManager.setPayConfirmDisabled(playerId.toString(), playerName, newState).thenRun(() -> {
                String messageKey = newState ? "commands.payconfirmtoggle.disabled" : "commands.payconfirmtoggle.enabled";
                player.sendMessage(this.langManager.getMessageFor(player, messageKey, "<green>Payment confirmations have been <yellow>{state}</yellow>.", LanguageManager.ComponentPlaceholder.of("{state}", newState ? "disabled" : "enabled")));
            });
        })).exceptionally(ex -> {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.payconfirmtoggle.error", "<red>Error toggling confirmation state. Please try again.", new LanguageManager.ComponentPlaceholder[0]));
            return null;
        });
        return true;
    }
}

